/*
 * Decompiled with CFR 0.152.
 */
package brut.directory;

import brut.directory.AbstractDirectory;
import brut.directory.DirectoryException;
import brut.directory.PathNotExist;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ZipRODirectory
extends AbstractDirectory {
    private final ZipFile mZipFile;
    private final String mPath;

    public ZipRODirectory(String zipFileName) throws DirectoryException {
        this(zipFileName, "");
    }

    public ZipRODirectory(File zipFile) throws DirectoryException {
        this(zipFile, "");
    }

    public ZipRODirectory(ZipFile zipFile) {
        this(zipFile, "");
    }

    public ZipRODirectory(String zipFileName, String path) throws DirectoryException {
        this(new File(zipFileName), path);
    }

    public ZipRODirectory(File zipFile, String path) throws DirectoryException {
        try {
            this.mZipFile = new ZipFile(zipFile);
        }
        catch (IOException e) {
            throw new DirectoryException(e);
        }
        this.mPath = path;
    }

    public ZipRODirectory(ZipFile zipFile, String path) {
        this.mZipFile = zipFile;
        this.mPath = path;
    }

    @Override
    protected AbstractDirectory createDirLocal(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected InputStream getFileInputLocal(String name) throws DirectoryException {
        try {
            return this.getZipFile().getInputStream(new ZipEntry(this.getPath() + name));
        }
        catch (IOException e) {
            throw new PathNotExist(name, e);
        }
    }

    @Override
    protected OutputStream getFileOutputLocal(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void loadDirs() {
        this.loadAll();
    }

    @Override
    protected void loadFiles() {
        this.loadAll();
    }

    @Override
    protected void removeFileLocal(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getSize(String fileName) throws DirectoryException {
        ZipEntry entry = this.getZipFileEntry(fileName);
        return entry.getSize();
    }

    @Override
    public long getCompressedSize(String fileName) throws DirectoryException {
        ZipEntry entry = this.getZipFileEntry(fileName);
        return entry.getCompressedSize();
    }

    @Override
    public int getCompressionLevel(String fileName) throws DirectoryException {
        ZipEntry entry = this.getZipFileEntry(fileName);
        return entry.getMethod();
    }

    private ZipEntry getZipFileEntry(String fileName) throws DirectoryException {
        ZipEntry entry = this.mZipFile.getEntry(fileName);
        if (entry == null) {
            throw new PathNotExist("Entry not found: " + fileName);
        }
        return entry;
    }

    private void loadAll() {
        this.mFiles = new LinkedHashSet();
        this.mDirs = new LinkedHashMap();
        int prefixLen = this.getPath().length();
        Enumeration<? extends ZipEntry> entries = this.getZipFile().entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            String name = entry.getName();
            if (name.equals(this.getPath()) || !name.startsWith(this.getPath()) || name.contains("../")) continue;
            String subname = name.substring(prefixLen);
            int pos = subname.indexOf(47);
            if (pos == -1) {
                if (!entry.isDirectory()) {
                    this.mFiles.add(subname);
                    continue;
                }
            } else {
                subname = subname.substring(0, pos);
            }
            if (this.mDirs.containsKey(subname)) continue;
            ZipRODirectory dir = new ZipRODirectory(this.getZipFile(), this.getPath() + subname + '/');
            this.mDirs.put(subname, dir);
        }
    }

    private String getPath() {
        return this.mPath;
    }

    private ZipFile getZipFile() {
        return this.mZipFile;
    }

    @Override
    public void close() throws IOException {
        this.mZipFile.close();
    }
}

