/*
 * Decompiled with CFR 0.152.
 */
package brut.directory;

import brut.common.BrutException;
import brut.common.InvalidUnknownFileException;
import brut.common.RootUnknownFileException;
import brut.common.TraversalUnknownFileException;
import brut.directory.Directory;
import brut.directory.DirectoryException;
import brut.util.BrutIO;
import brut.util.OS;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.logging.Logger;

public class DirUtil {
    private static final Logger LOGGER = Logger.getLogger("");

    private DirUtil() {
    }

    public static void copyToDir(Directory in, Directory out) throws DirectoryException {
        for (String fileName : in.getFiles(true)) {
            DirUtil.copyToDir(in, out, fileName);
        }
    }

    public static void copyToDir(Directory in, Directory out, String[] fileNames) throws DirectoryException {
        for (String fileName : fileNames) {
            DirUtil.copyToDir(in, out, fileName);
        }
    }

    public static void copyToDir(Directory in, Directory out, String fileName) throws DirectoryException {
        DirUtil.copyToDir(in, out, fileName, fileName);
    }

    public static void copyToDir(Directory in, Directory out, String inFile, String outFile) throws DirectoryException {
        try {
            if (in.containsDir(inFile)) {
                in.getDir(inFile).copyToDir(out.createDir(outFile));
            } else {
                BrutIO.copyAndClose((InputStream)in.getFileInput(inFile), (OutputStream)out.getFileOutput(outFile));
            }
        }
        catch (IOException ex) {
            throw new DirectoryException("Error copying file: " + inFile, ex);
        }
    }

    public static void copyToDir(Directory in, File out) throws DirectoryException {
        for (String fileName : in.getFiles(true)) {
            DirUtil.copyToDir(in, out, fileName);
        }
    }

    public static void copyToDir(Directory in, File out, String[] fileNames) throws DirectoryException {
        for (String fileName : fileNames) {
            DirUtil.copyToDir(in, out, fileName);
        }
    }

    public static void copyToDir(Directory in, File out, String fileName) throws DirectoryException {
        try {
            String cleanedFilename;
            if (in.containsDir(fileName)) {
                OS.rmdir((File)new File(out, fileName));
                in.getDir(fileName).copyToDir(new File(out, fileName));
            } else if ((in.containsDir(fileName) || in.containsFile(fileName)) && !(cleanedFilename = BrutIO.sanitizeFilepath((File)out, (String)fileName)).isEmpty()) {
                File outFile = new File(out, cleanedFilename);
                outFile.getParentFile().mkdirs();
                BrutIO.copyAndClose((InputStream)in.getFileInput(fileName), (OutputStream)Files.newOutputStream(outFile.toPath(), new OpenOption[0]));
            }
        }
        catch (FileSystemException exception) {
            LOGGER.warning(String.format("Skipping file %s (%s)", fileName, exception.getReason()));
        }
        catch (InvalidUnknownFileException | RootUnknownFileException | TraversalUnknownFileException | IOException exception) {
            LOGGER.warning(String.format("Skipping file %s (%s)", fileName, exception.getMessage()));
        }
        catch (BrutException ex) {
            throw new DirectoryException("Error copying file: " + fileName, ex);
        }
    }
}

