/*
 * Decompiled with CFR 0.152.
 */
package brut.xmlpull;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.Objects;
import org.xmlpull.v1.XmlSerializer;

public class MXSerializer
implements XmlSerializer {
    public static final String FEATURE_ATTR_VALUE_NO_ESCAPE = "http://xmlpull.org/v1/doc/features.html#attr-value-no-escape";
    public static final String FEATURE_NAMES_INTERNED = "http://xmlpull.org/v1/doc/features.html#names-interned";
    public static final String PROPERTY_DEFAULT_ENCODING = "http://xmlpull.org/v1/doc/properties.html#default-encoding";
    public static final String PROPERTY_INDENTATION = "http://xmlpull.org/v1/doc/properties.html#indentation";
    public static final String PROPERTY_LINE_SEPARATOR = "http://xmlpull.org/v1/doc/properties.html#line-separator";
    public static final String PROPERTY_LOCATION = "http://xmlpull.org/v1/doc/properties.html#location";
    private static final boolean TRACE_SIZING = false;
    private static final boolean TRACE_ESCAPING = false;
    private static final String XML_URI = "http://www.w3.org/XML/1998/namespace";
    private static final String XMLNS_URI = "http://www.w3.org/2000/xmlns/";
    private boolean namesInterned;
    private boolean attrValueNoEscape;
    private String defaultEncoding;
    private String indentationString;
    private String lineSeparator;
    private String location;
    private Writer writer;
    private int autoDeclaredPrefixes;
    private int depth = 0;
    private String[] elNamespace = new String[2];
    private String[] elName = new String[this.elNamespace.length];
    private String[] elPrefix = new String[this.elNamespace.length];
    private int[] elNamespaceCount = new int[this.elNamespace.length];
    private int namespaceEnd = 0;
    private String[] namespacePrefix = new String[8];
    private String[] namespaceUri = new String[this.namespacePrefix.length];
    private boolean finished;
    private boolean pastRoot;
    private boolean setPrefixCalled;
    private boolean startTagIncomplete;
    private boolean doIndent;
    private boolean seenTag;
    private boolean seenBracket;
    private boolean seenBracketBracket;
    private static final String[] precomputedPrefixes = new String[32];
    private final boolean checkNamesInterned = false;
    private static final int BUFFER_LEN = 8192;
    private final char[] buffer = new char[8192];
    private int bufidx;
    private static final int MAX_INDENT = 65;
    private int offsetNewLine;
    private int indentationJump;
    private char[] indentationBuf;
    private int maxIndentLevel;
    private boolean writeLineSeparator;
    private boolean writeIndentation;

    private void checkInterning(String name) {
        if (this.namesInterned && !Objects.equals(name, name.intern())) {
            throw new IllegalArgumentException("all names passed as arguments must be internedwhen NAMES INTERNED feature is enabled");
        }
    }

    private String getLocation() {
        return this.location != null ? " @" + this.location : "";
    }

    private void ensureElementsCapacity() {
        int elStackSize = this.elName.length;
        int newSize = (this.depth >= 7 ? 2 * this.depth : 8) + 2;
        boolean needsCopying = elStackSize > 0;
        String[] arr = new String[newSize];
        if (needsCopying) {
            System.arraycopy(this.elName, 0, arr, 0, elStackSize);
        }
        this.elName = arr;
        arr = new String[newSize];
        if (needsCopying) {
            System.arraycopy(this.elPrefix, 0, arr, 0, elStackSize);
        }
        this.elPrefix = arr;
        arr = new String[newSize];
        if (needsCopying) {
            System.arraycopy(this.elNamespace, 0, arr, 0, elStackSize);
        }
        this.elNamespace = arr;
        int[] iarr = new int[newSize];
        if (needsCopying) {
            System.arraycopy(this.elNamespaceCount, 0, iarr, 0, elStackSize);
        } else {
            iarr[0] = 0;
        }
        this.elNamespaceCount = iarr;
    }

    private void ensureNamespacesCapacity() {
        int newSize = this.namespaceEnd > 7 ? 2 * this.namespaceEnd : 8;
        String[] newNamespacePrefix = new String[newSize];
        String[] newNamespaceUri = new String[newSize];
        if (this.namespacePrefix != null) {
            System.arraycopy(this.namespacePrefix, 0, newNamespacePrefix, 0, this.namespaceEnd);
            System.arraycopy(this.namespaceUri, 0, newNamespaceUri, 0, this.namespaceEnd);
        }
        this.namespacePrefix = newNamespacePrefix;
        this.namespaceUri = newNamespaceUri;
    }

    private void flushBuffer() throws IOException {
        if (this.bufidx > 0) {
            this.writer.write(this.buffer, 0, this.bufidx);
            this.writer.flush();
            this.bufidx = 0;
        }
    }

    private void write(char ch) throws IOException {
        if (this.bufidx >= 8192) {
            this.flushBuffer();
        }
        this.buffer[this.bufidx++] = ch;
    }

    private void write(char[] buf, int i, int length) throws IOException {
        while (length > 0) {
            int batch;
            if (this.bufidx == 8192) {
                this.flushBuffer();
            }
            if ((batch = 8192 - this.bufidx) > length) {
                batch = length;
            }
            System.arraycopy(buf, i, this.buffer, this.bufidx, batch);
            i += batch;
            length -= batch;
            this.bufidx += batch;
        }
    }

    private void write(String str) throws IOException {
        if (str == null) {
            str = "";
        }
        this.write(str, 0, str.length());
    }

    private void write(String str, int i, int length) throws IOException {
        while (length > 0) {
            int batch;
            if (this.bufidx == 8192) {
                this.flushBuffer();
            }
            if ((batch = 8192 - this.bufidx) > length) {
                batch = length;
            }
            str.getChars(i, i + batch, this.buffer, this.bufidx);
            i += batch;
            length -= batch;
            this.bufidx += batch;
        }
    }

    private void rebuildIndentationBuf() {
        int i;
        if (!this.doIndent) {
            return;
        }
        int bufSize = 0;
        this.offsetNewLine = 0;
        if (this.writeLineSeparator) {
            this.offsetNewLine = this.lineSeparator.length();
            bufSize += this.offsetNewLine;
        }
        this.maxIndentLevel = 0;
        if (this.writeIndentation) {
            this.indentationJump = this.indentationString.length();
            this.maxIndentLevel = 65 / this.indentationJump;
            bufSize += this.maxIndentLevel * this.indentationJump;
        }
        if (this.indentationBuf == null || this.indentationBuf.length < bufSize) {
            this.indentationBuf = new char[bufSize + 8];
        }
        int bufPos = 0;
        if (this.writeLineSeparator) {
            for (i = 0; i < this.lineSeparator.length(); ++i) {
                this.indentationBuf[bufPos++] = this.lineSeparator.charAt(i);
            }
        }
        if (this.writeIndentation) {
            for (i = 0; i < this.maxIndentLevel; ++i) {
                for (int j = 0; j < this.indentationString.length(); ++j) {
                    this.indentationBuf[bufPos++] = this.indentationString.charAt(j);
                }
            }
        }
    }

    private void writeIndent() throws IOException {
        int start = this.writeLineSeparator ? 0 : this.offsetNewLine;
        int level = Math.min(this.depth, this.maxIndentLevel);
        this.write(this.indentationBuf, start, (level - 1) * this.indentationJump + this.offsetNewLine);
    }

    public void setFeature(String name, boolean state) throws IllegalArgumentException, IllegalStateException {
        if (name == null) {
            throw new IllegalArgumentException("feature name can not be null");
        }
        switch (name) {
            case "http://xmlpull.org/v1/doc/features.html#attr-value-no-escape": {
                this.attrValueNoEscape = state;
                break;
            }
            case "http://xmlpull.org/v1/doc/features.html#names-interned": {
                this.namesInterned = state;
                break;
            }
            default: {
                throw new IllegalStateException("unsupported feature: " + name);
            }
        }
    }

    public boolean getFeature(String name) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("feature name can not be null");
        }
        switch (name) {
            case "http://xmlpull.org/v1/doc/features.html#attr-value-no-escape": {
                return this.attrValueNoEscape;
            }
            case "http://xmlpull.org/v1/doc/features.html#names-interned": {
                return this.namesInterned;
            }
        }
        return false;
    }

    public void setProperty(String name, Object value) throws IllegalArgumentException, IllegalStateException {
        if (name == null) {
            throw new IllegalArgumentException("property name can not be null");
        }
        switch (name) {
            case "http://xmlpull.org/v1/doc/properties.html#default-encoding": {
                this.defaultEncoding = (String)value;
                break;
            }
            case "http://xmlpull.org/v1/doc/properties.html#indentation": {
                this.indentationString = (String)value;
                break;
            }
            case "http://xmlpull.org/v1/doc/properties.html#line-separator": {
                this.lineSeparator = (String)value;
                break;
            }
            case "http://xmlpull.org/v1/doc/properties.html#location": {
                this.location = (String)value;
                break;
            }
            default: {
                throw new IllegalStateException("unsupported property: " + name);
            }
        }
        this.writeLineSeparator = this.lineSeparator != null && !this.lineSeparator.isEmpty();
        this.writeIndentation = this.indentationString != null && !this.indentationString.isEmpty();
        this.doIndent = this.indentationString != null && (this.writeLineSeparator || this.writeIndentation);
        this.rebuildIndentationBuf();
        this.seenTag = false;
    }

    public Object getProperty(String name) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("property name can not be null");
        }
        switch (name) {
            case "http://xmlpull.org/v1/doc/properties.html#default-encoding": {
                return this.defaultEncoding;
            }
            case "http://xmlpull.org/v1/doc/properties.html#indentation": {
                return this.indentationString;
            }
            case "http://xmlpull.org/v1/doc/properties.html#line-separator": {
                return this.lineSeparator;
            }
            case "http://xmlpull.org/v1/doc/properties.html#location": {
                return this.location;
            }
        }
        return null;
    }

    public void setOutput(Writer writer) {
        this.writer = writer;
        this.location = null;
        this.autoDeclaredPrefixes = 0;
        this.depth = 0;
        for (int i = 0; i < this.elNamespaceCount.length; ++i) {
            this.elName[i] = null;
            this.elPrefix[i] = null;
            this.elNamespace[i] = null;
            this.elNamespaceCount[i] = 2;
        }
        this.namespaceEnd = 0;
        this.namespacePrefix[this.namespaceEnd] = "xmlns";
        this.namespaceUri[this.namespaceEnd] = XMLNS_URI;
        ++this.namespaceEnd;
        this.namespacePrefix[this.namespaceEnd] = "xml";
        this.namespaceUri[this.namespaceEnd] = XML_URI;
        ++this.namespaceEnd;
        this.finished = false;
        this.pastRoot = false;
        this.setPrefixCalled = false;
        this.startTagIncomplete = false;
        this.seenTag = false;
        this.seenBracket = false;
        this.seenBracketBracket = false;
    }

    public void setOutput(OutputStream os, String encoding) throws IOException {
        if (os == null) {
            throw new IllegalArgumentException("output stream can not be null");
        }
        if (encoding == null) {
            encoding = this.defaultEncoding;
        }
        this.setOutput(encoding != null ? new OutputStreamWriter(os, encoding) : new OutputStreamWriter(os));
    }

    public void startDocument(String encoding, Boolean standalone) throws IOException {
        this.write("<?xml version=\"1.0\"");
        if (encoding == null) {
            encoding = this.defaultEncoding;
        }
        if (encoding != null) {
            this.write(" encoding=\"");
            this.write(encoding);
            this.write('\"');
        }
        if (standalone != null) {
            this.write(" standalone=\"");
            if (standalone.booleanValue()) {
                this.write("yes");
            } else {
                this.write("no");
            }
            this.write('\"');
        }
        this.write("?>");
        if (this.writeLineSeparator) {
            this.write(this.lineSeparator);
        }
    }

    public void endDocument() throws IOException {
        while (this.depth > 0) {
            this.endTag(this.elNamespace[this.depth], this.elName[this.depth]);
        }
        if (this.writeLineSeparator) {
            this.write(this.lineSeparator);
        }
        this.flushBuffer();
        this.startTagIncomplete = true;
        this.pastRoot = true;
        this.finished = true;
    }

    public void setPrefix(String prefix, String namespace) throws IOException {
        if (this.startTagIncomplete) {
            this.closeStartTag();
        }
        if (prefix == null) {
            prefix = "";
        }
        if (!this.namesInterned) {
            prefix = prefix.intern();
        } else if (prefix == null) {
            throw new IllegalArgumentException("prefix must be not null" + this.getLocation());
        }
        if (!this.namesInterned) {
            namespace = namespace.intern();
        } else if (namespace == null) {
            throw new IllegalArgumentException("namespace must be not null" + this.getLocation());
        }
        if (this.namespaceEnd >= this.namespacePrefix.length) {
            this.ensureNamespacesCapacity();
        }
        this.namespacePrefix[this.namespaceEnd] = prefix;
        this.namespaceUri[this.namespaceEnd] = namespace;
        ++this.namespaceEnd;
        this.setPrefixCalled = true;
    }

    public String getPrefix(String namespace, boolean generatePrefix) {
        return this.getPrefix(namespace, generatePrefix, false);
    }

    private String getPrefix(String namespace, boolean generatePrefix, boolean nonEmpty) {
        if (!this.namesInterned) {
            namespace = namespace.intern();
        }
        if (namespace == null) {
            throw new IllegalArgumentException("namespace must be not null" + this.getLocation());
        }
        if (namespace.isEmpty()) {
            throw new IllegalArgumentException("default namespace cannot have prefix" + this.getLocation());
        }
        for (int i = this.namespaceEnd - 1; i >= 0; --i) {
            if (!namespace.equals(this.namespaceUri[i])) continue;
            String prefix = this.namespacePrefix[i];
            if (nonEmpty && prefix.isEmpty()) continue;
            return prefix;
        }
        if (!generatePrefix) {
            return null;
        }
        return this.generatePrefix(namespace);
    }

    public int getDepth() {
        return this.depth;
    }

    public String getNamespace() {
        return this.elNamespace[this.depth];
    }

    public String getName() {
        return this.elName[this.depth];
    }

    public XmlSerializer startTag(String namespace, String name) throws IOException {
        if (this.startTagIncomplete) {
            this.closeStartTag();
        }
        this.seenBracketBracket = false;
        this.seenBracket = false;
        ++this.depth;
        if (this.doIndent && this.depth > 0 && this.seenTag) {
            this.writeIndent();
        }
        this.seenTag = true;
        this.setPrefixCalled = false;
        this.startTagIncomplete = true;
        if (this.depth + 1 >= this.elName.length) {
            this.ensureElementsCapacity();
        }
        this.elNamespace[this.depth] = this.namesInterned || namespace == null ? namespace : namespace.intern();
        String string = this.elName[this.depth] = this.namesInterned || name == null ? name : name.intern();
        if (this.writer == null) {
            throw new IllegalStateException("setOutput() must called set before serialization can start");
        }
        this.write('<');
        if (namespace != null) {
            if (!namespace.isEmpty()) {
                String uri;
                String prefix = null;
                if (this.depth > 0 && this.namespaceEnd - this.elNamespaceCount[this.depth - 1] == 1 && ((uri = this.namespaceUri[this.namespaceEnd - 1]) == namespace || uri.equals(namespace))) {
                    String elPfx = this.namespacePrefix[this.namespaceEnd - 1];
                    for (int pos = this.elNamespaceCount[this.depth - 1] - 1; pos >= 2; --pos) {
                        String pf = this.namespacePrefix[pos];
                        if (pf != elPfx && !pf.equals(elPfx)) continue;
                        String n = this.namespaceUri[pos];
                        if (n != uri && !n.equals(uri)) break;
                        --this.namespaceEnd;
                        prefix = elPfx;
                        break;
                    }
                }
                if (prefix == null) {
                    prefix = this.getPrefix(namespace, true, false);
                }
                if (!prefix.isEmpty()) {
                    this.elPrefix[this.depth] = prefix;
                    this.write(prefix);
                    this.write(':');
                } else {
                    this.elPrefix[this.depth] = "";
                }
            } else {
                for (int i = this.namespaceEnd - 1; i >= 0; --i) {
                    if (this.namespacePrefix[i] != "") continue;
                    String uri = this.namespaceUri[i];
                    if (uri == null) {
                        this.setPrefix("", "");
                        break;
                    }
                    if (uri.isEmpty()) break;
                    throw new IllegalStateException("start tag can not be written in empty default namespace as default namespace is currently bound to '" + uri + "'" + this.getLocation());
                }
                this.elPrefix[this.depth] = "";
            }
        } else {
            this.elPrefix[this.depth] = "";
        }
        this.write(name);
        return this;
    }

    private void closeStartTag() throws IOException {
        if (this.finished) {
            throw new IllegalArgumentException("trying to write past already finished output" + this.getLocation());
        }
        if (this.seenBracket) {
            this.seenBracketBracket = false;
            this.seenBracket = false;
        }
        if (this.startTagIncomplete || this.setPrefixCalled) {
            if (this.setPrefixCalled) {
                throw new IllegalArgumentException("startTag() must be called immediately after setPrefix()" + this.getLocation());
            }
            if (!this.startTagIncomplete) {
                throw new IllegalArgumentException("trying to close start tag that is not opened" + this.getLocation());
            }
            this.writeNamespaceDeclarations();
            this.write('>');
            this.elNamespaceCount[this.depth] = this.namespaceEnd;
            this.startTagIncomplete = false;
        }
    }

    public XmlSerializer attribute(String namespace, String name, String value) throws IOException {
        if (!this.startTagIncomplete) {
            throw new IllegalArgumentException("startTag() must be called before attribute()" + this.getLocation());
        }
        this.write(' ');
        if (namespace != null && !namespace.isEmpty()) {
            String prefix;
            if (!this.namesInterned) {
                namespace = namespace.intern();
            }
            if ((prefix = this.getPrefix(namespace, false, true)) == null) {
                prefix = this.generatePrefix(namespace);
            }
            this.write(prefix);
            this.write(':');
        }
        this.write(name);
        this.write("=\"");
        this.writeAttributeValue(value);
        this.write('\"');
        return this;
    }

    public XmlSerializer endTag(String namespace, String name) throws IOException {
        this.seenBracketBracket = false;
        this.seenBracket = false;
        if (namespace != null && !this.namesInterned) {
            namespace = namespace.intern();
        }
        if (name == null) {
            throw new IllegalArgumentException("end tag name can not be null" + this.getLocation());
        }
        if (this.startTagIncomplete) {
            this.writeNamespaceDeclarations();
            this.write(" />");
        } else {
            if (this.doIndent && this.seenTag) {
                this.writeIndent();
            }
            this.write("</");
            String startTagPrefix = this.elPrefix[this.depth];
            if (!startTagPrefix.isEmpty()) {
                this.write(startTagPrefix);
                this.write(':');
            }
            this.write(name);
            this.write('>');
        }
        --this.depth;
        this.namespaceEnd = this.elNamespaceCount[this.depth];
        this.startTagIncomplete = false;
        this.seenTag = true;
        return this;
    }

    public XmlSerializer text(String text) throws IOException {
        if (this.startTagIncomplete || this.setPrefixCalled) {
            this.closeStartTag();
        }
        if (this.doIndent && this.seenTag) {
            this.seenTag = false;
        }
        this.writeElementContent(text);
        return this;
    }

    public XmlSerializer text(char[] buf, int start, int len) throws IOException {
        if (this.startTagIncomplete || this.setPrefixCalled) {
            this.closeStartTag();
        }
        if (this.doIndent && this.seenTag) {
            this.seenTag = false;
        }
        this.writeElementContent(buf, start, len);
        return this;
    }

    public void cdsect(String text) throws IOException {
        if (this.startTagIncomplete || this.setPrefixCalled || this.seenBracket) {
            this.closeStartTag();
        }
        if (this.doIndent && this.seenTag) {
            this.seenTag = false;
        }
        this.write("<![CDATA[");
        this.write(text);
        this.write("]]>");
    }

    public void entityRef(String text) throws IOException {
        if (this.startTagIncomplete || this.setPrefixCalled || this.seenBracket) {
            this.closeStartTag();
        }
        if (this.doIndent && this.seenTag) {
            this.seenTag = false;
        }
        this.write('&');
        this.write(text);
        this.write(';');
    }

    public void processingInstruction(String text) throws IOException {
        if (this.startTagIncomplete || this.setPrefixCalled || this.seenBracket) {
            this.closeStartTag();
        }
        if (this.doIndent && this.seenTag) {
            this.seenTag = false;
        }
        this.write("<?");
        this.write(text);
        this.write("?>");
    }

    public void comment(String text) throws IOException {
        if (this.startTagIncomplete || this.setPrefixCalled || this.seenBracket) {
            this.closeStartTag();
        }
        if (this.doIndent && this.seenTag) {
            this.seenTag = false;
        }
        this.write("<!--");
        this.write(text);
        this.write("-->");
    }

    public void docdecl(String text) throws IOException {
        if (this.startTagIncomplete || this.setPrefixCalled || this.seenBracket) {
            this.closeStartTag();
        }
        if (this.doIndent && this.seenTag) {
            this.seenTag = false;
        }
        this.write("<!DOCTYPE");
        this.write(text);
        this.write(">");
    }

    public void ignorableWhitespace(String text) throws IOException {
        if (this.startTagIncomplete || this.setPrefixCalled || this.seenBracket) {
            this.closeStartTag();
        }
        if (this.doIndent && this.seenTag) {
            this.seenTag = false;
        }
        if (text.isEmpty()) {
            throw new IllegalArgumentException("empty string is not allowed for ignorable whitespace" + this.getLocation());
        }
        this.write(text);
    }

    public void flush() throws IOException {
        if (!this.finished && this.startTagIncomplete) {
            this.closeStartTag();
        }
        this.flushBuffer();
    }

    private String generatePrefix(String namespace) {
        String prefix;
        ++this.autoDeclaredPrefixes;
        String string = prefix = this.autoDeclaredPrefixes < precomputedPrefixes.length ? precomputedPrefixes[this.autoDeclaredPrefixes] : ("n" + this.autoDeclaredPrefixes).intern();
        if (this.namespaceEnd >= this.namespacePrefix.length) {
            this.ensureNamespacesCapacity();
        }
        this.namespacePrefix[this.namespaceEnd] = prefix;
        this.namespaceUri[this.namespaceEnd] = namespace;
        ++this.namespaceEnd;
        return prefix;
    }

    private void writeNamespaceDeclarations() throws IOException {
        HashSet<String> uniqueNamespaces = new HashSet<String>();
        for (int i = this.elNamespaceCount[this.depth - 1]; i < this.namespaceEnd; ++i) {
            String prefix = this.namespacePrefix[i];
            String uri = this.namespaceUri[i];
            if (uniqueNamespaces.contains(prefix + uri)) continue;
            if (this.doIndent && uri.length() > 40) {
                this.writeIndent();
                this.write(' ');
            }
            this.write(" xmlns");
            if (prefix != "") {
                this.write(':');
                this.write(prefix);
            }
            this.write("=\"");
            this.writeAttributeValue(uri);
            this.write('\"');
            uniqueNamespaces.add(prefix + uri);
        }
    }

    private void writeAttributeValue(String value) throws IOException {
        if (this.attrValueNoEscape) {
            this.write(value);
            return;
        }
        int pos = 0;
        for (int i = 0; i < value.length(); ++i) {
            char ch = value.charAt(i);
            if (ch == '&') {
                if (i > pos) {
                    this.write(value.substring(pos, i));
                }
                this.write("&amp;");
                pos = i + 1;
            }
            if (ch == '<') {
                if (i > pos) {
                    this.write(value.substring(pos, i));
                }
                this.write("&lt;");
                pos = i + 1;
                continue;
            }
            if (ch == '\"') {
                if (i > pos) {
                    this.write(value.substring(pos, i));
                }
                this.write("&quot;");
                pos = i + 1;
                continue;
            }
            if (ch >= ' ') continue;
            if (ch == '\r' || ch == '\n' || ch == '\t') {
                if (i > pos) {
                    this.write(value.substring(pos, i));
                }
                this.write("&#");
                this.write(Integer.toString(ch));
                this.write(';');
                pos = i + 1;
                continue;
            }
            throw new IllegalStateException("character " + MXSerializer.printable(ch) + " (" + Integer.toString(ch) + ") is not allowed in output" + this.getLocation() + " (attr value=" + MXSerializer.printable(value) + ")");
        }
        this.write(pos > 0 ? value.substring(pos) : value);
    }

    private void writeElementContent(String text) throws IOException {
        if (text == null) {
            return;
        }
        int pos = 0;
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (ch == ']') {
                if (this.seenBracket) {
                    this.seenBracketBracket = true;
                    continue;
                }
                this.seenBracket = true;
                continue;
            }
            if (ch == '&') {
                if (i >= text.length() - 3 || text.charAt(i + 1) != 'l' || text.charAt(i + 2) != 't' || text.charAt(i + 3) != ';') {
                    if (i > pos) {
                        this.write(text.substring(pos, i));
                    }
                    this.write("&amp;");
                    pos = i + 1;
                }
            } else if (ch == '<') {
                if (i > pos) {
                    this.write(text.substring(pos, i));
                }
                this.write("&lt;");
                pos = i + 1;
            } else if (this.seenBracketBracket && ch == '>') {
                if (i > pos) {
                    this.write(text.substring(pos, i));
                }
                this.write("&gt;");
                pos = i + 1;
            } else if (ch < ' ' && ch != '\t' && ch != '\n' && ch != '\r') {
                throw new IllegalStateException("character " + Integer.toString(ch) + " is not allowed in output" + this.getLocation() + " (text value=" + MXSerializer.printable(text) + ")");
            }
            if (!this.seenBracket) continue;
            this.seenBracket = false;
            this.seenBracketBracket = false;
        }
        this.write(pos > 0 ? text.substring(pos) : text);
    }

    private void writeElementContent(char[] buf, int off, int len) throws IOException {
        int end = off + len;
        int pos = off;
        for (int i = off; i < end; ++i) {
            char ch = buf[i];
            if (ch == ']') {
                if (this.seenBracket) {
                    this.seenBracketBracket = true;
                    continue;
                }
                this.seenBracket = true;
                continue;
            }
            if (ch == '&') {
                if (i > pos) {
                    this.write(buf, pos, i - pos);
                }
                this.write("&amp;");
                pos = i + 1;
            } else if (ch == '<') {
                if (i > pos) {
                    this.write(buf, pos, i - pos);
                }
                this.write("&lt;");
                pos = i + 1;
            } else if (this.seenBracketBracket && ch == '>') {
                if (i > pos) {
                    this.write(buf, pos, i - pos);
                }
                this.write("&gt;");
                pos = i + 1;
            } else if (ch < ' ' && ch != '\t' && ch != '\n' && ch != '\r') {
                throw new IllegalStateException("character " + MXSerializer.printable(ch) + " (" + Integer.toString(ch) + ") is not allowed in output" + this.getLocation());
            }
            if (!this.seenBracket) continue;
            this.seenBracket = false;
            this.seenBracketBracket = false;
        }
        if (end > pos) {
            this.write(buf, pos, end - pos);
        }
    }

    private static String printable(String str) {
        if (str == null) {
            return "null";
        }
        StringBuffer retval = new StringBuffer(str.length() + 16);
        retval.append("'");
        for (int i = 0; i < str.length(); ++i) {
            MXSerializer.addPrintable(retval, str.charAt(i));
        }
        retval.append("'");
        return retval.toString();
    }

    private static String printable(char ch) {
        StringBuffer retval = new StringBuffer();
        MXSerializer.addPrintable(retval, ch);
        return retval.toString();
    }

    private static void addPrintable(StringBuffer retval, char ch) {
        switch (ch) {
            case '\b': {
                retval.append("\\b");
                break;
            }
            case '\t': {
                retval.append("\\t");
                break;
            }
            case '\n': {
                retval.append("\\n");
                break;
            }
            case '\f': {
                retval.append("\\f");
                break;
            }
            case '\r': {
                retval.append("\\r");
                break;
            }
            case '\"': {
                retval.append("\\\"");
                break;
            }
            case '\'': {
                retval.append("\\'");
                break;
            }
            case '\\': {
                retval.append("\\\\");
                break;
            }
            default: {
                if (ch < ' ' || ch > '~') {
                    String str = "0000" + Integer.toString(ch, 16);
                    retval.append("\\u").append(str.substring(str.length() - 4));
                    break;
                }
                retval.append(ch);
            }
        }
    }

    static {
        for (int i = 0; i < precomputedPrefixes.length; ++i) {
            MXSerializer.precomputedPrefixes[i] = ("n" + i).intern();
        }
    }
}

