/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.ahc;

import io.netty.buffer.ByteBuf;
import org.appenders.log4j2.elasticsearch.BatchBuilder;
import org.appenders.log4j2.elasticsearch.BatchOperations;
import org.appenders.log4j2.elasticsearch.ItemSource;
import org.appenders.log4j2.elasticsearch.LifeCycle;
import org.appenders.log4j2.elasticsearch.PooledItemSourceFactory;
import org.appenders.log4j2.elasticsearch.ahc.BatchRequest;
import org.appenders.log4j2.elasticsearch.ahc.BatchResult;
import org.appenders.log4j2.elasticsearch.ahc.ClientAPIFactory;
import org.appenders.log4j2.elasticsearch.ahc.IndexRequest;
import org.appenders.log4j2.elasticsearch.metrics.Measured;
import org.appenders.log4j2.elasticsearch.metrics.MetricsRegistry;

public class AHCBatchOperations
implements BatchOperations<BatchRequest>,
LifeCycle,
Measured {
    private volatile LifeCycle.State state = LifeCycle.State.STOPPED;
    protected final PooledItemSourceFactory batchBufferFactory;
    private final ClientAPIFactory<IndexRequest.Builder, BatchRequest.Builder, BatchResult> builderFactory;

    public AHCBatchOperations(PooledItemSourceFactory batchBufferFactory, ClientAPIFactory<IndexRequest.Builder, BatchRequest.Builder, BatchResult> builderFactory) {
        this.batchBufferFactory = batchBufferFactory;
        this.builderFactory = builderFactory;
    }

    public Object createBatchItem(String target, Object source) {
        throw new UnsupportedOperationException("Use ItemSource based API instead");
    }

    public Object createBatchItem(String target, ItemSource payload) {
        return this.builderFactory.itemBuilder(target, payload).build();
    }

    public BatchBuilder<BatchRequest> createBatchBuilder() {
        return new BatchBuilder<BatchRequest>(){
            private final BatchRequest.Builder builder;
            {
                this.builder = ((BatchRequest.Builder)AHCBatchOperations.this.builderFactory.batchBuilder()).withBuffer((ItemSource<ByteBuf>)AHCBatchOperations.this.batchBufferFactory.createEmptySource());
            }

            public void add(Object item) {
                this.builder.add(item);
            }

            public BatchRequest build() {
                return this.builder.build();
            }
        };
    }

    public void start() {
        if (this.isStarted()) {
            return;
        }
        this.batchBufferFactory.start();
        this.state = LifeCycle.State.STARTED;
    }

    public void stop() {
        if (this.isStopped()) {
            return;
        }
        this.batchBufferFactory.stop();
        this.state = LifeCycle.State.STOPPED;
    }

    public boolean isStarted() {
        return this.state == LifeCycle.State.STARTED;
    }

    public boolean isStopped() {
        return this.state == LifeCycle.State.STOPPED;
    }

    public void register(MetricsRegistry registry) {
        Measured.of((Object)this.batchBufferFactory).register(registry);
    }

    public void deregister() {
        Measured.of((Object)this.batchBufferFactory).deregister();
    }
}

