/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.ahc;

import org.appenders.log4j2.elasticsearch.Credentials;
import org.appenders.log4j2.elasticsearch.ahc.HttpClientFactory;
import org.asynchttpclient.Realm;

public final class BasicCredentials
implements Credentials<HttpClientFactory.Builder> {
    static final String PLUGIN_NAME = "BasicCredentials";
    private final String username;
    private final String password;

    public BasicCredentials(String username, String password) {
        this.username = username;
        this.password = password;
    }

    public void applyTo(HttpClientFactory.Builder builder) {
        Realm realm = new Realm.Builder(this.username, this.password).setUsePreemptiveAuth(true).setScheme(Realm.AuthScheme.BASIC).build();
        builder.withRealm(realm);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String username;
        private String password;

        public BasicCredentials build() {
            if (this.username == null) {
                throw new IllegalArgumentException("No username provided for BasicCredentials");
            }
            if (this.password == null) {
                throw new IllegalArgumentException("No password provided for BasicCredentials");
            }
            return new BasicCredentials(this.username, this.password);
        }

        public Builder withUsername(String username) {
            this.username = username;
            return this;
        }

        public Builder withPassword(String password) {
            this.password = password;
            return this;
        }
    }
}

