/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.ahc;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import org.appenders.log4j2.elasticsearch.Deserializer;
import org.appenders.log4j2.elasticsearch.ItemSource;
import org.appenders.log4j2.elasticsearch.QueueFactory;
import org.appenders.log4j2.elasticsearch.Serializer;
import org.appenders.log4j2.elasticsearch.ahc.Batch;
import org.appenders.log4j2.elasticsearch.ahc.BatchResult;
import org.appenders.log4j2.elasticsearch.ahc.IndexRequest;
import org.appenders.log4j2.elasticsearch.util.UriUtil;

public class BatchRequest
implements Batch<IndexRequest> {
    public static final String HTTP_METHOD_NAME = "POST";
    public static final char LINE_SEPARATOR = '\n';
    private final Serializer<Object> itemSerializer;
    private final Deserializer<BatchResult> resultDeserializer;
    private ItemSource<ByteBuf> buffer;
    protected final Collection<IndexRequest> indexRequests;
    private final int size;
    final String uri;

    protected BatchRequest(Builder builder) {
        this.indexRequests = QueueFactory.getQueueFactoryInstance((String)BatchRequest.class.getSimpleName()).toIterable(builder.items);
        this.size = this.indexRequests.size();
        this.itemSerializer = builder.itemSerializer;
        this.resultDeserializer = builder.resultDeserializer;
        this.buffer = builder.buffer;
        this.uri = builder.uriBuilder.toString();
    }

    @Override
    public ItemSource serialize() throws Exception {
        ByteBufOutputStream byteBufOutputStream = new ByteBufOutputStream((ByteBuf)this.buffer.getSource());
        IndexRequest identicalAction = this.uniformAction(this.indexRequests);
        byte[] actionTemplate = identicalAction != null ? this.itemSerializer.writeAsBytes((Object)identicalAction) : null;
        for (IndexRequest action : this.indexRequests) {
            if (actionTemplate == null) {
                this.itemSerializer.write((OutputStream)byteBufOutputStream, (Object)action);
            } else {
                byteBufOutputStream.write(actionTemplate);
            }
            byteBufOutputStream.writeByte(10);
            ByteBuf source = (ByteBuf)action.getSource().getSource();
            ((ByteBuf)this.buffer.getSource()).writeBytes(source);
            byteBufOutputStream.writeByte(10);
        }
        return this.buffer;
    }

    public BatchResult deserialize(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            return BatchResult.INPUT_STREAM_NULL;
        }
        return (BatchResult)this.resultDeserializer.read(inputStream);
    }

    IndexRequest uniformAction(Collection<IndexRequest> indexRequests) {
        IndexRequest current = null;
        for (IndexRequest indexRequest : indexRequests) {
            if (current == null) {
                current = indexRequest;
                continue;
            }
            boolean sameIndex = current.sameIndex(indexRequest);
            boolean sameType = current.sameType(indexRequest);
            if (sameIndex && sameType) continue;
            return null;
        }
        return current;
    }

    @Override
    public void completed() {
        for (IndexRequest indexRequest : this.indexRequests) {
            indexRequest.completed();
        }
        this.indexRequests.clear();
        this.buffer.release();
        this.buffer = null;
    }

    @Override
    public Collection<IndexRequest> getItems() {
        return this.indexRequests;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public String getURI() {
        return this.uri;
    }

    @Override
    public String getHttpMethodName() {
        return HTTP_METHOD_NAME;
    }

    public static class Builder {
        private static final int INITIAL_SIZE = Integer.parseInt(System.getProperty("appenders." + BatchRequest.class.getSimpleName() + ".initialSize", "8192"));
        protected final Collection<IndexRequest> items;
        protected final StringBuilder uriBuilder = new StringBuilder(32);
        private ItemSource<ByteBuf> buffer;
        private Serializer<Object> itemSerializer;
        private Deserializer<BatchResult> resultDeserializer;

        public Builder() {
            this(QueueFactory.getQueueFactoryInstance((String)BatchRequest.class.getSimpleName()).tryCreateMpscQueue(INITIAL_SIZE));
        }

        Builder(Collection<IndexRequest> items) {
            this.items = items;
            UriUtil.appendPath((StringBuilder)this.uriBuilder, (String)"_bulk");
        }

        public Builder add(Object item) {
            this.add((IndexRequest)item);
            return this;
        }

        public Builder add(IndexRequest item) {
            this.items.add(item);
            return this;
        }

        public Builder add(Collection<? extends IndexRequest> items) {
            this.items.addAll(items);
            return this;
        }

        public BatchRequest build() {
            this.validate();
            return new BatchRequest(this);
        }

        protected void validate() {
            if (this.buffer == null) {
                throw new IllegalArgumentException("buffer cannot be null");
            }
            if (this.itemSerializer == null) {
                throw new IllegalArgumentException("itemSerializer cannot be null");
            }
            if (this.resultDeserializer == null) {
                throw new IllegalArgumentException("resultDeserializer cannot be null");
            }
        }

        public Builder withFilterPath(String filterPath) {
            UriUtil.appendQueryParam((StringBuilder)this.uriBuilder, (String)"filter_path", (String)filterPath);
            return this;
        }

        public Builder withBuffer(ItemSource<ByteBuf> buffer) {
            this.buffer = buffer;
            return this;
        }

        public Builder withItemSerializer(Serializer<Object> serializer) {
            this.itemSerializer = serializer;
            return this;
        }

        public Builder withResultDeserializer(Deserializer<BatchResult> deserializer) {
            this.resultDeserializer = deserializer;
            return this;
        }
    }
}

