/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.ahc;

import java.util.List;
import java.util.Optional;
import org.appenders.log4j2.elasticsearch.ahc.BatchItemResult;
import org.appenders.log4j2.elasticsearch.ahc.Error;
import org.appenders.log4j2.elasticsearch.ahc.Response;

public class BatchResult
implements Response {
    static final BatchResult INPUT_STREAM_NULL;
    private static final int ERROR_MAX_STACK_DEPTH;
    static final String UNABLE_TO_GET_MORE_INFO = "Unable to extract error info from failed items";
    static final String ONE_OR_MORE_ITEMS_FAILED = "One or more items failed";
    static final String FIRST_FAILED_ITEM_PREFIX = "First failed item: ";
    static final String ROOT_ERROR_PREFIX = "Root error: ";
    private static final String SEPARATOR = ". ";
    private final int took;
    private final boolean errors;
    private final Error error;
    private final int statusCode;
    private final List<BatchItemResult> items;
    private String errorMessage;
    private int responseCode;

    public BatchResult(int took, boolean errors, Error error, int statusCode, List<BatchItemResult> items) {
        this.took = took;
        this.errors = errors;
        this.error = error;
        this.statusCode = statusCode;
        this.items = items;
    }

    public int getTook() {
        return this.took;
    }

    public boolean hasErrors() {
        return this.errors;
    }

    @Override
    public boolean isSucceeded() {
        return !this.errors && this.error == null;
    }

    public Error getError() {
        return this.error;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public List<BatchItemResult> getItems() {
        return this.items;
    }

    @Override
    public int getResponseCode() {
        return this.responseCode;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public BatchResult withResponseCode(int responseCode) {
        this.responseCode = responseCode;
        return this;
    }

    private StringBuilder appendFailedItemErrorMessageIfAvailable(StringBuilder sb) {
        if (this.getItems() == null) {
            return sb.append(UNABLE_TO_GET_MORE_INFO);
        }
        Optional<BatchItemResult> firstFailedItem = this.getItems().stream().filter(item -> item.getError() != null).findFirst();
        if (!firstFailedItem.isPresent()) {
            return sb.append(UNABLE_TO_GET_MORE_INFO);
        }
        sb.append(FIRST_FAILED_ITEM_PREFIX);
        return firstFailedItem.get().getError().appendErrorMessage(sb, ERROR_MAX_STACK_DEPTH);
    }

    @Override
    public BatchResult withErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        if (this.isSucceeded()) {
            return this;
        }
        StringBuilder sb = new StringBuilder(256);
        sb.append(errorMessage);
        if (this.errors) {
            sb.append(SEPARATOR).append(ONE_OR_MORE_ITEMS_FAILED);
            this.appendFailedItemErrorMessageIfAvailable(sb.append(SEPARATOR));
        }
        if (this.statusCode > 0) {
            sb.append(SEPARATOR).append("status: ").append(this.statusCode);
        }
        if (this.getError() != null) {
            sb.append(SEPARATOR).append(ROOT_ERROR_PREFIX);
            this.getError().appendErrorMessage(sb, ERROR_MAX_STACK_DEPTH);
        }
        this.errorMessage = sb.toString();
        return this;
    }

    static {
        Error error = new Error();
        error.setReason("inputStream is null");
        INPUT_STREAM_NULL = new CopyingBatchResult(new BatchResult(0, false, error, 500, null));
        ERROR_MAX_STACK_DEPTH = Integer.parseInt(System.getProperty("appenders." + BatchResult.class.getSimpleName() + ".error.depth", "3"));
    }

    private static class CopyingBatchResult
    extends BatchResult {
        CopyingBatchResult(BatchResult batchResult) {
            super(batchResult.took, batchResult.errors, batchResult.error, batchResult.statusCode, batchResult.items);
        }

        @Override
        public final BatchResult withErrorMessage(String errorMessage) {
            return new BatchResult(this.getTook(), this.hasErrors(), this.getError(), this.getStatusCode(), this.getItems()).withErrorMessage(errorMessage);
        }

        @Override
        public final BatchResult withResponseCode(int responseCode) {
            return new BatchResult(this.getTook(), this.hasErrors(), this.getError(), this.getResponseCode(), this.getItems()).withResponseCode(responseCode);
        }
    }
}

