/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.ahc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.appenders.core.logging.InternalLogging;
import org.appenders.log4j2.elasticsearch.ClientObjectFactory;
import org.appenders.log4j2.elasticsearch.ClientProvider;
import org.appenders.log4j2.elasticsearch.FailoverPolicy;
import org.appenders.log4j2.elasticsearch.LifeCycle;
import org.appenders.log4j2.elasticsearch.Operation;
import org.appenders.log4j2.elasticsearch.ahc.AHCHttp;
import org.appenders.log4j2.elasticsearch.ahc.Batch;
import org.appenders.log4j2.elasticsearch.ahc.BatchResult;
import org.appenders.log4j2.elasticsearch.ahc.HttpClient;
import org.appenders.log4j2.elasticsearch.ahc.HttpClientFactory;
import org.appenders.log4j2.elasticsearch.ahc.HttpClientProvider;
import org.appenders.log4j2.elasticsearch.ahc.Item;
import org.appenders.log4j2.elasticsearch.ahc.Request;
import org.appenders.log4j2.elasticsearch.ahc.ResponseHandler;
import org.appenders.log4j2.elasticsearch.backoff.BackoffPolicy;
import org.appenders.log4j2.elasticsearch.backoff.NoopBackoffPolicy;
import org.appenders.log4j2.elasticsearch.failover.FailedItemOps;
import org.appenders.log4j2.elasticsearch.metrics.DefaultMetricsFactory;
import org.appenders.log4j2.elasticsearch.metrics.Measured;
import org.appenders.log4j2.elasticsearch.metrics.Metric;
import org.appenders.log4j2.elasticsearch.metrics.MetricConfig;
import org.appenders.log4j2.elasticsearch.metrics.MetricConfigFactory;
import org.appenders.log4j2.elasticsearch.metrics.Metrics;
import org.appenders.log4j2.elasticsearch.metrics.MetricsFactory;
import org.appenders.log4j2.elasticsearch.metrics.MetricsRegistry;

public abstract class BatchingClientObjectFactory<BATCH_TYPE extends Batch<ITEM_TYPE>, ITEM_TYPE extends Item<?>>
implements ClientObjectFactory<HttpClient, BATCH_TYPE>,
Measured {
    private volatile LifeCycle.State state = LifeCycle.State.STOPPED;
    protected final HttpClientProvider clientProvider;
    protected final FailedItemOps<ITEM_TYPE> failedItemOps;
    protected final BackoffPolicy<BATCH_TYPE> backoffPolicy;
    protected final BatchingClientMetrics metrics;
    private final ConcurrentLinkedQueue<Operation> operations = new ConcurrentLinkedQueue();

    public BatchingClientObjectFactory(Builder<BATCH_TYPE, ITEM_TYPE> builder) {
        this.clientProvider = builder.clientProvider;
        this.failedItemOps = builder.failedItemOps;
        this.backoffPolicy = builder.backoffPolicy;
        this.metrics = new BatchingClientMetrics(((Builder)builder).name, builder.metricsFactory);
    }

    public Function<BATCH_TYPE, Boolean> createFailureHandler(FailoverPolicy failover) {
        return batchRequest -> {
            long start = System.currentTimeMillis();
            this.metrics.batchFailed();
            Collection items = batchRequest.getItems();
            int batchSize = batchRequest.size();
            this.metrics.itemsFailed(batchSize);
            InternalLogging.getLogger().warn("Batch of {} items failed. Redirecting to {}", new Object[]{batchSize, failover.getClass().getName()});
            items.forEach(batchItem -> {
                try {
                    failover.deliver(this.failedItemOps.createItem(batchItem));
                }
                catch (Exception e) {
                    InternalLogging.getLogger().error(e.getMessage(), new Object[]{e});
                }
            });
            this.metrics.failoverTookMs(System.currentTimeMillis() - start);
            return true;
        };
    }

    protected abstract ResponseHandler<BatchResult> createResultHandler(BATCH_TYPE var1, Function<BATCH_TYPE, Boolean> var2);

    public Collection<String> getServerList() {
        return new ArrayList<String>(this.clientProvider.getHttpClientFactoryBuilder().serverList);
    }

    public HttpClient createClient() {
        return this.clientProvider.createClient();
    }

    public Function<BATCH_TYPE, Boolean> createBatchListener(final FailoverPolicy failoverPolicy) {
        return new Function<BATCH_TYPE, Boolean>(){
            private final Function<BATCH_TYPE, Boolean> failureHandler;
            {
                this.failureHandler = BatchingClientObjectFactory.this.createFailureHandler(failoverPolicy);
            }

            @Override
            public Boolean apply(BATCH_TYPE request) {
                while (!BatchingClientObjectFactory.this.operations.isEmpty()) {
                    try {
                        ((Operation)BatchingClientObjectFactory.this.operations.remove()).execute();
                    }
                    catch (Exception e) {
                        InternalLogging.getLogger().error("before-batch failed: " + e.getMessage(), new Object[]{e});
                    }
                }
                if (BatchingClientObjectFactory.this.backoffPolicy.shouldApply(request)) {
                    InternalLogging.getLogger().warn("Backoff applied. Batch of {} items rejected", new Object[]{request.size()});
                    BatchingClientObjectFactory.this.metrics.backoffApplied(1);
                    this.failureHandler.apply(request);
                    request.completed();
                    return false;
                }
                BatchingClientObjectFactory.this.backoffPolicy.register(request);
                ResponseHandler<BatchResult> responseHandler = BatchingClientObjectFactory.this.createResultHandler(request, this.failureHandler);
                BatchingClientObjectFactory.this.createClient().executeAsync((Request)request, responseHandler);
                BatchingClientObjectFactory.this.metrics.itemsSent(request.size());
                return true;
            }
        };
    }

    public void addOperation(Operation operation) {
        this.operations.add(operation);
    }

    public final void start() {
        if (this.isStarted()) {
            return;
        }
        this.addOperation(() -> LifeCycle.of((Object)this.clientProvider).start());
        this.startExtensions();
        this.state = LifeCycle.State.STARTED;
    }

    public final void stop() {
        if (this.isStopped()) {
            return;
        }
        InternalLogging.getLogger().debug("Stopping {}", new Object[]{this.getClass().getSimpleName()});
        this.stopExtensions();
        LifeCycle.of((Object)this.clientProvider).stop();
        this.state = LifeCycle.State.STOPPED;
        InternalLogging.getLogger().debug("{} stopped", new Object[]{this.getClass().getSimpleName()});
    }

    public final boolean isStarted() {
        return this.state == LifeCycle.State.STARTED;
    }

    public final boolean isStopped() {
        return this.state == LifeCycle.State.STOPPED;
    }

    public void register(MetricsRegistry registry) {
        this.metrics.register(registry);
        this.addOperation(() -> Measured.of((Object)this.clientProvider).register(registry));
        this.addOperation(() -> Measured.of((Object)this.clientProvider.getHttpClientFactoryBuilder().serviceDiscovery).register(registry));
    }

    public void deregister() {
        this.metrics.deregister();
        Measured.of((Object)this.clientProvider).deregister();
        Measured.of((Object)this.clientProvider.getHttpClientFactoryBuilder().serviceDiscovery).deregister();
    }

    public static class BatchingClientMetrics
    implements Metrics {
        private final List<MetricsRegistry.Registration> registrations = new ArrayList<MetricsRegistry.Registration>();
        private final Metric serverTookMs;
        private final Metric itemsSent;
        private final Metric itemsDelivered;
        private final Metric itemsFailed;
        private final Metric backoffApplied;
        private final Metric batchesFailed;
        private final Metric failoverTookMs;

        public BatchingClientMetrics(String name, MetricsFactory factory) {
            this.serverTookMs = factory.createMetric(name, "serverTookMs");
            this.itemsSent = factory.createMetric(name, "itemsSent");
            this.itemsDelivered = factory.createMetric(name, "itemsDelivered");
            this.itemsFailed = factory.createMetric(name, "itemsFailed");
            this.backoffApplied = factory.createMetric(name, "backoffApplied");
            this.batchesFailed = factory.createMetric(name, "batchesFailed");
            this.failoverTookMs = factory.createMetric(name, "failoverTookMs");
        }

        public static List<MetricConfig> metricConfigs(boolean enabled) {
            return Collections.unmodifiableList(Arrays.asList(MetricConfigFactory.createMaxConfig((boolean)enabled, (String)"serverTookMs", (boolean)true), MetricConfigFactory.createCountConfig((boolean)enabled, (String)"itemsSent"), MetricConfigFactory.createCountConfig((boolean)enabled, (String)"itemsDelivered"), MetricConfigFactory.createCountConfig((boolean)enabled, (String)"itemsFailed"), MetricConfigFactory.createCountConfig((boolean)enabled, (String)"backoffApplied"), MetricConfigFactory.createCountConfig((boolean)enabled, (String)"batchesFailed"), MetricConfigFactory.createMaxConfig((boolean)enabled, (String)"failoverTookMs", (boolean)true)));
        }

        public void register(MetricsRegistry registry) {
            this.registrations.add(registry.register(this.serverTookMs));
            this.registrations.add(registry.register(this.itemsSent));
            this.registrations.add(registry.register(this.itemsDelivered));
            this.registrations.add(registry.register(this.itemsFailed));
            this.registrations.add(registry.register(this.backoffApplied));
            this.registrations.add(registry.register(this.batchesFailed));
            this.registrations.add(registry.register(this.failoverTookMs));
        }

        public void deregister() {
            this.registrations.forEach(MetricsRegistry.Registration::deregister);
            this.registrations.clear();
        }

        public void serverTookMs(int tookMs) {
            this.serverTookMs.store(tookMs);
        }

        public void itemsSent(int itemsSent) {
            this.itemsSent.store(itemsSent);
        }

        public void itemsDelivered(int count) {
            this.itemsDelivered.store(count);
        }

        public void itemsFailed(int count) {
            this.itemsFailed.store(count);
        }

        public void backoffApplied(int count) {
            this.backoffApplied.store(count);
        }

        public void batchFailed() {
            this.batchesFailed.store(1);
        }

        public void failoverTookMs(long tookMs) {
            this.failoverTookMs.store(tookMs);
        }
    }

    public static abstract class Builder<BATCH_TYPE extends Batch<ITEM_TYPE>, ITEM_TYPE extends Item<?>> {
        private static final AtomicInteger counter = new AtomicInteger();
        private String name = BatchingClientMetrics.class.getSimpleName() + "-" + counter.getAndIncrement();
        protected HttpClientProvider clientProvider = new HttpClientProvider(new HttpClientFactory.Builder());
        protected BackoffPolicy<BATCH_TYPE> backoffPolicy = new NoopBackoffPolicy();
        protected FailedItemOps<ITEM_TYPE> failedItemOps;
        protected final MetricsFactory metricsFactory = new DefaultMetricsFactory(BatchingClientMetrics.metricConfigs(false));

        public abstract BatchingClientObjectFactory<BATCH_TYPE, ITEM_TYPE> build();

        protected Builder<BATCH_TYPE, ITEM_TYPE> validate() {
            if (this.clientProvider == null) {
                throw new IllegalArgumentException(this.nullValidationExceptionMessage(ClientProvider.class.getSimpleName()));
            }
            if (this.backoffPolicy == null) {
                throw new IllegalArgumentException(this.nullValidationExceptionMessage(BackoffPolicy.class.getSimpleName()));
            }
            if (this.failedItemOps == null) {
                this.failedItemOps = this.createFailedItemOps();
            }
            return this;
        }

        protected abstract FailedItemOps<ITEM_TYPE> createFailedItemOps();

        private String nullValidationExceptionMessage(String className) {
            return String.format("No %s provided for %s", className, AHCHttp.class.getSimpleName());
        }

        public Builder<BATCH_TYPE, ITEM_TYPE> withName(String name) {
            this.name = name;
            return this;
        }

        public Builder<BATCH_TYPE, ITEM_TYPE> withClientProvider(HttpClientProvider clientProvider) {
            this.clientProvider = clientProvider;
            return this;
        }

        public Builder<BATCH_TYPE, ITEM_TYPE> withBackoffPolicy(BackoffPolicy<BATCH_TYPE> backoffPolicy) {
            this.backoffPolicy = backoffPolicy;
            return this;
        }

        public Builder<BATCH_TYPE, ITEM_TYPE> withFailedItemOps(FailedItemOps<ITEM_TYPE> failedItemOps) {
            this.failedItemOps = failedItemOps;
            return this;
        }

        public Builder<BATCH_TYPE, ITEM_TYPE> withMetricConfig(MetricConfig metricConfig) {
            this.metricsFactory.configure(metricConfig);
            return this;
        }

        public Builder<BATCH_TYPE, ITEM_TYPE> withMetricConfigs(List<MetricConfig> metricConfigs) {
            this.metricsFactory.configure(metricConfigs);
            return this;
        }
    }
}

