/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.ahc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.appenders.core.logging.InternalLogging;
import org.appenders.log4j2.elasticsearch.ClientProvider;
import org.appenders.log4j2.elasticsearch.ahc.ClientProviderPolicy;
import org.appenders.log4j2.elasticsearch.ahc.HttpClient;
import org.appenders.log4j2.elasticsearch.ahc.HttpClientFactory;
import org.appenders.log4j2.elasticsearch.ahc.HttpClientProvider;

public class ClientProviderPoliciesRegistry {
    private final Map<String, CopyingConfigPolicy<HttpClient>> copyingPolicies = new HashMap<String, CopyingConfigPolicy<HttpClient>>();

    public ClientProviderPoliciesRegistry() {
        this.register(new InheritServerUrisConfig());
        this.register(new InheritSecurityConfig());
    }

    final List<String> availablePolicies() {
        ArrayList<String> validPolicies = new ArrayList<String>(Arrays.asList("shared", "none"));
        validPolicies.addAll(this.copyingPolicies.keySet());
        return validPolicies;
    }

    final void register(CopyingConfigPolicy<HttpClient> policy) {
        this.copyingPolicies.put(policy.getName(), policy);
    }

    public final ClientProviderPolicy<HttpClient> get(Set<String> policies, HttpClientProvider initialClientProvider) {
        this.validatePolicyList(policies);
        if (this.isValidExclusivePolicy(policies, "shared")) {
            return new SharedHttpClient();
        }
        if (this.isValidExclusivePolicy(policies, "none")) {
            return new NewHttpClient(initialClientProvider);
        }
        CopyingConfigPolicyChain propertiesProcessor = new CopyingConfigPolicyChain(initialClientProvider);
        for (String policyName : policies) {
            propertiesProcessor.add(this.copyingPolicies.get(policyName));
        }
        return propertiesProcessor;
    }

    private void validatePolicyList(Set<String> policies) {
        if (policies == null || policies.isEmpty()) {
            throw new IllegalArgumentException("Policy list must present. Valid policies: " + this.availablePolicies());
        }
        List<String> availablePolicies = this.availablePolicies();
        for (String policyName : policies) {
            if (availablePolicies.contains(policyName)) continue;
            throw new IllegalArgumentException("Invalid policy specified: [" + policyName + "]. Available policies: " + availablePolicies);
        }
    }

    private boolean isValidExclusivePolicy(Set<String> policies, String shared) {
        if (policies.contains(shared)) {
            this.ensureNoOtherPolicies(policies, shared);
            return true;
        }
        return false;
    }

    private void ensureNoOtherPolicies(Set<String> policies, String policyName) {
        if (policies.size() > 1) {
            throw new IllegalArgumentException("Cannot apply other policies when [" + policyName + "] policy is used");
        }
    }

    private static class InheritSecurityConfig
    implements CopyingConfigPolicy<HttpClient> {
        private InheritSecurityConfig() {
        }

        @Override
        public String getName() {
            return "security";
        }

        @Override
        public void copy(ClientProvider<HttpClient> source, ClientProvider<HttpClient> target) {
            HttpClientFactory.Builder src = ((HttpClientProvider)source).getHttpClientFactoryBuilder();
            HttpClientFactory.Builder builder = ((HttpClientProvider)target).getHttpClientFactoryBuilder();
            PropertiesMapper.copyProperty("auth", () -> src.auth, () -> builder.auth, builder::withAuth);
            PropertiesMapper.copyProperty("realm", () -> src.realm, () -> builder.realm, builder::withRealm);
            PropertiesMapper.copyProperty("sslEngineFactory", () -> src.sslEngineFactory, () -> builder.sslEngineFactory, builder::withSslEngineFactory);
        }
    }

    private static class InheritServerUrisConfig
    implements CopyingConfigPolicy<HttpClient> {
        private InheritServerUrisConfig() {
        }

        @Override
        public String getName() {
            return "serverList";
        }

        @Override
        public void copy(ClientProvider<HttpClient> source, ClientProvider<HttpClient> target) {
            HttpClientFactory.Builder src = ((HttpClientProvider)source).getHttpClientFactoryBuilder();
            HttpClientFactory.Builder builder = ((HttpClientProvider)target).getHttpClientFactoryBuilder();
            PropertiesMapper.copyProperty("serverList", () -> src.serverList, () -> builder.serverList, builder::withServerList);
        }
    }

    private static class SharedHttpClient
    implements ClientProviderPolicy<HttpClient> {
        private SharedHttpClient() {
        }

        @Override
        public ClientProvider<HttpClient> apply(ClientProvider<HttpClient> source) {
            InternalLogging.getLogger().info("{}: Parent config reused. Resolved config: {}", new Object[]{SharedHttpClient.class.getSimpleName(), source});
            return source;
        }
    }

    private static class NewHttpClient
    implements ClientProviderPolicy<HttpClient> {
        private final HttpClientProvider target;

        private NewHttpClient(HttpClientProvider httpClientProvider) {
            this.target = httpClientProvider;
        }

        @Override
        public ClientProvider<HttpClient> apply(ClientProvider<HttpClient> source) {
            InternalLogging.getLogger().info("{}: Parent config ignored. Resolved config: {}", new Object[]{NewHttpClient.class, this.target});
            return this.target;
        }
    }

    private static class CopyingConfigPolicyChain
    implements ClientProviderPolicy<HttpClient> {
        private final List<CopyingConfigPolicy<HttpClient>> policies = new ArrayList<CopyingConfigPolicy<HttpClient>>();
        private final ClientProvider<HttpClient> target;

        public CopyingConfigPolicyChain(ClientProvider<HttpClient> target) {
            this.target = target;
        }

        void add(CopyingConfigPolicy<HttpClient> policy) {
            this.policies.add(policy);
        }

        @Override
        public ClientProvider<HttpClient> apply(ClientProvider<HttpClient> source) {
            this.process(source, this.target);
            InternalLogging.getLogger().info("{}: Properties processed. Resolved config: {}", new Object[]{CopyingConfigPolicyChain.class.getSimpleName(), this.target});
            return this.target;
        }

        private void process(ClientProvider<HttpClient> source, ClientProvider<HttpClient> target) {
            for (CopyingConfigPolicy<HttpClient> policy : this.policies) {
                policy.copy(source, target);
            }
        }
    }

    static class PropertiesMapper {
        private PropertiesMapper() {
        }

        static <T> void copyProperty(String propertyName, Supplier<T> sourceValueProvider, Supplier<T> targetValueProvider, Consumer<T> valueConsumer) {
            if (!PropertiesMapper.isEmpty(targetValueProvider.get())) {
                InternalLogging.getLogger().debug("{}: Skipping [{}] as target value is not empty", new Object[]{PropertiesMapper.class.getSimpleName(), propertyName});
                return;
            }
            if (PropertiesMapper.isEmpty(sourceValueProvider.get())) {
                InternalLogging.getLogger().debug("{}: Skipping [{}] as source value is empty", new Object[]{PropertiesMapper.class.getSimpleName(), propertyName});
                return;
            }
            valueConsumer.accept(sourceValueProvider.get());
        }

        private static <T> boolean isEmpty(T value) {
            if (value == null) {
                return true;
            }
            if (value instanceof String) {
                return ((String)value).trim().isEmpty();
            }
            if (value instanceof Collection) {
                return ((Collection)value).isEmpty();
            }
            return false;
        }
    }

    public static interface CopyingConfigPolicy<T> {
        public String getName();

        public void copy(ClientProvider<T> var1, ClientProvider<T> var2);
    }
}

