/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.ahc;

import io.netty.buffer.ByteBuf;
import java.util.Collections;
import org.appenders.log4j2.elasticsearch.ComponentTemplate;
import org.appenders.log4j2.elasticsearch.EmptyItemSourceFactory;
import org.appenders.log4j2.elasticsearch.ItemSource;
import org.appenders.log4j2.elasticsearch.OpSource;
import org.appenders.log4j2.elasticsearch.Operation;
import org.appenders.log4j2.elasticsearch.OperationFactory;
import org.appenders.log4j2.elasticsearch.SetupStep;
import org.appenders.log4j2.elasticsearch.SkippingSetupStepChain;
import org.appenders.log4j2.elasticsearch.StepProcessor;
import org.appenders.log4j2.elasticsearch.ValueResolver;
import org.appenders.log4j2.elasticsearch.ahc.ByteBufItemSourceWriter;
import org.appenders.log4j2.elasticsearch.ahc.PutComponentTemplate;
import org.appenders.log4j2.elasticsearch.ahc.Request;
import org.appenders.log4j2.elasticsearch.ahc.Response;

public class ComponentTemplateSetupOp
implements OperationFactory {
    protected final StepProcessor<SetupStep<Request, Response>> stepProcessor;
    protected final ValueResolver valueResolver;
    protected final EmptyItemSourceFactory itemSourceFactory;
    private final ByteBufItemSourceWriter writer = new ByteBufItemSourceWriter();

    public ComponentTemplateSetupOp(StepProcessor<SetupStep<Request, Response>> stepProcessor, ValueResolver valueResolver, EmptyItemSourceFactory itemSourceFactory) {
        this.stepProcessor = stepProcessor;
        this.valueResolver = valueResolver;
        this.itemSourceFactory = itemSourceFactory;
    }

    public <T extends OpSource> Operation create(T opSource) {
        ComponentTemplate componentTemplate = (ComponentTemplate)opSource;
        ItemSource emptySource = this.itemSourceFactory.createEmptySource();
        PutComponentTemplate putComponentTemplate = new PutComponentTemplate(componentTemplate.getName(), this.writer.write((ItemSource<ByteBuf>)emptySource, this.valueResolver.resolve(componentTemplate.getSource()).getBytes()));
        return new SkippingSetupStepChain(Collections.singletonList(putComponentTemplate), this.stepProcessor);
    }
}

