/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.ahc;

import java.util.Collection;
import org.appenders.log4j2.elasticsearch.ahc.BatchRequest;
import org.appenders.log4j2.elasticsearch.ahc.IndexRequest;

public class DataStreamBatchRequest
extends BatchRequest {
    private IndexRequest first;

    protected DataStreamBatchRequest(Builder builder) {
        super(builder);
    }

    @Override
    IndexRequest uniformAction(Collection<IndexRequest> indexRequests) {
        for (IndexRequest indexRequest : indexRequests) {
            if (this.first == null) {
                this.first = indexRequest;
                continue;
            }
            boolean sameIndex = this.first.sameIndex(indexRequest);
            if (sameIndex) continue;
            throw new IllegalArgumentException("Items for different indices found: " + this.first.getIndex() + " != " + indexRequest.getIndex());
        }
        return this.first;
    }

    @Override
    public String getURI() {
        return this.uniformAction(this.indexRequests).getIndex() + this.uri;
    }

    @Override
    public String getHttpMethodName() {
        return "POST";
    }

    public static class Builder
    extends BatchRequest.Builder {
        @Override
        public DataStreamBatchRequest build() {
            this.validate();
            return new DataStreamBatchRequest(this);
        }
    }
}

