/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.ahc;

import java.util.Arrays;
import org.appenders.log4j2.elasticsearch.DataStream;
import org.appenders.log4j2.elasticsearch.EmptyItemSourceFactory;
import org.appenders.log4j2.elasticsearch.OpSource;
import org.appenders.log4j2.elasticsearch.Operation;
import org.appenders.log4j2.elasticsearch.OperationFactory;
import org.appenders.log4j2.elasticsearch.SetupStep;
import org.appenders.log4j2.elasticsearch.SkippingSetupStepChain;
import org.appenders.log4j2.elasticsearch.StepProcessor;
import org.appenders.log4j2.elasticsearch.ahc.CheckDataStream;
import org.appenders.log4j2.elasticsearch.ahc.CreateDataStream;
import org.appenders.log4j2.elasticsearch.ahc.Request;
import org.appenders.log4j2.elasticsearch.ahc.Response;

public class DataStreamSetupOp
implements OperationFactory {
    protected final StepProcessor<SetupStep<Request, Response>> stepProcessor;
    protected final EmptyItemSourceFactory itemSourceFactory;

    public DataStreamSetupOp(StepProcessor<SetupStep<Request, Response>> stepProcessor, EmptyItemSourceFactory itemSourceFactory) {
        this.stepProcessor = stepProcessor;
        this.itemSourceFactory = itemSourceFactory;
    }

    public <T extends OpSource> Operation create(T opSource) {
        DataStream dataStream = (DataStream)opSource;
        CheckDataStream checkDataStream = new CheckDataStream(dataStream.getName());
        CreateDataStream createDataStream = new CreateDataStream(dataStream.getName(), this.itemSourceFactory.createEmptySource());
        return new SkippingSetupStepChain(Arrays.asList(new SetupStep[]{checkDataStream, createDataStream}), this.stepProcessor);
    }
}

