/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.ahc;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MappingJsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import io.netty.buffer.ByteBuf;
import org.appenders.log4j2.elasticsearch.Deserializer;
import org.appenders.log4j2.elasticsearch.ExtendedObjectMapper;
import org.appenders.log4j2.elasticsearch.ItemSource;
import org.appenders.log4j2.elasticsearch.JacksonDeserializer;
import org.appenders.log4j2.elasticsearch.JacksonSerializer;
import org.appenders.log4j2.elasticsearch.Serializer;
import org.appenders.log4j2.elasticsearch.ahc.BatchItemResult;
import org.appenders.log4j2.elasticsearch.ahc.BatchItemResultMixIn;
import org.appenders.log4j2.elasticsearch.ahc.BatchRequest;
import org.appenders.log4j2.elasticsearch.ahc.BatchResult;
import org.appenders.log4j2.elasticsearch.ahc.BatchResultMixIn;
import org.appenders.log4j2.elasticsearch.ahc.ClientAPIFactory;
import org.appenders.log4j2.elasticsearch.ahc.Error;
import org.appenders.log4j2.elasticsearch.ahc.ErrorMixIn;
import org.appenders.log4j2.elasticsearch.ahc.IndexRequest;
import org.appenders.log4j2.elasticsearch.ahc.IndexRequestMixIn;

public class ElasticsearchBulkAPI
implements ClientAPIFactory<IndexRequest.Builder, BatchRequest.Builder, BatchResult> {
    private final String mappingType;
    private final String filterPath;
    private final Serializer<Object> itemSerializer;
    private final Deserializer<BatchResult> resultDeserializer;

    public ElasticsearchBulkAPI() {
        this(null, null);
    }

    public ElasticsearchBulkAPI(String mappingType, String filterPath) {
        this.mappingType = mappingType;
        this.filterPath = filterPath;
        this.itemSerializer = this.createItemSerializer();
        this.resultDeserializer = this.createResultDeserializer();
    }

    public ElasticsearchBulkAPI(String mappingType, String filterPath, Serializer<Object> itemSerializer, Deserializer<BatchResult> resultDeserializer) {
        this.mappingType = mappingType;
        this.filterPath = filterPath;
        this.itemSerializer = itemSerializer;
        this.resultDeserializer = resultDeserializer;
    }

    @Override
    public IndexRequest.Builder itemBuilder(String target, ItemSource payload) {
        return new IndexRequest.Builder((ItemSource<ByteBuf>)payload).index(target).type(this.mappingType);
    }

    @Override
    public BatchRequest.Builder batchBuilder() {
        return new BatchRequest.Builder().withFilterPath(this.filterPath).withItemSerializer(this.itemSerializer).withResultDeserializer(this.resultDeserializer);
    }

    public Serializer<Object> createItemSerializer() {
        ObjectWriter objectWriter = ElasticsearchBulkAPI.defaultObjectMapper().writerFor(IndexRequest.class);
        return new JacksonSerializer(objectWriter);
    }

    public Deserializer<BatchResult> createResultDeserializer() {
        ObjectReader objectReader = ElasticsearchBulkAPI.defaultObjectMapper().readerFor(BatchResult.class);
        return new JacksonDeserializer(objectReader);
    }

    public static ObjectMapper defaultObjectMapper() {
        return new ExtendedObjectMapper((JsonFactory)new MappingJsonFactory()).setVisibility((VisibilityChecker)VisibilityChecker.Std.defaultInstance().with(JsonAutoDetect.Visibility.ANY)).setSerializationInclusion(JsonInclude.Include.NON_EMPTY).configure(SerializationFeature.CLOSE_CLOSEABLE, false).addMixIn(IndexRequest.class, IndexRequestMixIn.class).configure(DeserializationFeature.ACCEPT_EMPTY_ARRAY_AS_NULL_OBJECT, true).addMixIn(BatchResult.class, BatchResultMixIn.class).addMixIn(Error.class, ErrorMixIn.class).addMixIn(BatchItemResult.class, BatchItemResultMixIn.class);
    }
}

