/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.ahc;

import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import org.apache.logging.log4j.core.config.ConfigurationException;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.appenders.log4j2.elasticsearch.Deserializer;
import org.appenders.log4j2.elasticsearch.JacksonDeserializer;
import org.appenders.log4j2.elasticsearch.JacksonSerializer;
import org.appenders.log4j2.elasticsearch.Serializer;
import org.appenders.log4j2.elasticsearch.ahc.BatchResult;
import org.appenders.log4j2.elasticsearch.ahc.ElasticsearchBulkAPI;
import org.appenders.log4j2.elasticsearch.ahc.IndexRequest;

@Plugin(name="ElasticsearchBulk", category="Core", elementType="clientAPIFactory", printObject=true)
public class ElasticsearchBulkPlugin
extends ElasticsearchBulkAPI {
    private ElasticsearchBulkPlugin(Serializer<Object> itemSerializer, Deserializer<BatchResult> resultDeserializer, String mappingType, String filterPath) {
        super(mappingType, filterPath, itemSerializer, resultDeserializer);
    }

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder
    implements org.apache.logging.log4j.core.util.Builder<ElasticsearchBulkPlugin> {
        @PluginAttribute(value="mappingType")
        protected String mappingType;
        @PluginAttribute(value="filterPath")
        protected String filterPath;
        private Serializer<Object> itemSerializer = this.createItemSerializer();
        private Deserializer<BatchResult> resultDeserializer = this.createResultDeserializer();

        public ElasticsearchBulkPlugin build() {
            if (this.itemSerializer == null) {
                throw new ConfigurationException("itemSerializer cannot be null");
            }
            if (this.resultDeserializer == null) {
                throw new ConfigurationException("resultDeserializer cannot be null");
            }
            return new ElasticsearchBulkPlugin(this.itemSerializer, this.resultDeserializer, this.mappingType, this.filterPath);
        }

        public Builder withMappingType(String mappingType) {
            this.mappingType = mappingType;
            return this;
        }

        public Builder withFilterPath(String filterPath) {
            this.filterPath = filterPath;
            return this;
        }

        public Builder withItemSerializer(Serializer<Object> itemSerializer) {
            this.itemSerializer = itemSerializer;
            return this;
        }

        public Builder withResultDeserializer(Deserializer<BatchResult> resultDeserializer) {
            this.resultDeserializer = resultDeserializer;
            return this;
        }

        protected Serializer<Object> createItemSerializer() {
            ObjectWriter objectWriter = ElasticsearchBulkAPI.defaultObjectMapper().writerFor(IndexRequest.class);
            return new JacksonSerializer(objectWriter);
        }

        protected Deserializer<BatchResult> createResultDeserializer() {
            ObjectReader objectReader = ElasticsearchBulkAPI.defaultObjectMapper().readerFor(BatchResult.class);
            return new JacksonDeserializer(objectReader);
        }
    }
}

