/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.ahc;

import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import io.netty.buffer.ByteBuf;
import org.appenders.log4j2.elasticsearch.Deserializer;
import org.appenders.log4j2.elasticsearch.ItemSource;
import org.appenders.log4j2.elasticsearch.JacksonDeserializer;
import org.appenders.log4j2.elasticsearch.JacksonSerializer;
import org.appenders.log4j2.elasticsearch.Serializer;
import org.appenders.log4j2.elasticsearch.ahc.BatchItemResult;
import org.appenders.log4j2.elasticsearch.ahc.BatchRequest;
import org.appenders.log4j2.elasticsearch.ahc.BatchResult;
import org.appenders.log4j2.elasticsearch.ahc.ClientAPIFactory;
import org.appenders.log4j2.elasticsearch.ahc.DataStreamBatchRequest;
import org.appenders.log4j2.elasticsearch.ahc.DataStreamItem;
import org.appenders.log4j2.elasticsearch.ahc.DataStreamItemMixIn;
import org.appenders.log4j2.elasticsearch.ahc.DataStreamItemResultMixIn;
import org.appenders.log4j2.elasticsearch.ahc.ElasticsearchBulkAPI;
import org.appenders.log4j2.elasticsearch.ahc.IndexRequest;

public class ElasticsearchDataStreamAPI
implements ClientAPIFactory<IndexRequest.Builder, BatchRequest.Builder, BatchResult> {
    private final Serializer<Object> itemSerializer;
    private final Deserializer<BatchResult> resultDeserializer;
    private final String filterPath;

    public ElasticsearchDataStreamAPI() {
        this.itemSerializer = this.createItemSerializer();
        this.resultDeserializer = this.createResultDeserializer();
        this.filterPath = null;
    }

    public ElasticsearchDataStreamAPI(String filterPath) {
        this.itemSerializer = this.createItemSerializer();
        this.resultDeserializer = this.createResultDeserializer();
        this.filterPath = filterPath;
    }

    public ElasticsearchDataStreamAPI(Serializer<Object> itemSerializer, Deserializer<BatchResult> resultDeserializer) {
        this.itemSerializer = itemSerializer;
        this.resultDeserializer = resultDeserializer;
        this.filterPath = null;
    }

    public ElasticsearchDataStreamAPI(Serializer<Object> serializer, Deserializer<BatchResult> deserializer, String filterPath) {
        this.itemSerializer = serializer;
        this.resultDeserializer = deserializer;
        this.filterPath = filterPath;
    }

    @Override
    public IndexRequest.Builder itemBuilder(String target, ItemSource payload) {
        return new DataStreamItem.Builder((ItemSource<ByteBuf>)payload).index(target);
    }

    @Override
    public BatchRequest.Builder batchBuilder() {
        return new DataStreamBatchRequest.Builder().withFilterPath(this.filterPath).withItemSerializer(this.itemSerializer).withResultDeserializer(this.resultDeserializer);
    }

    protected Serializer<Object> createItemSerializer() {
        ObjectWriter objectWriter = ElasticsearchBulkAPI.defaultObjectMapper().addMixIn(IndexRequest.class, DataStreamItemMixIn.class).writerFor(IndexRequest.class);
        return new JacksonSerializer(objectWriter);
    }

    protected Deserializer<BatchResult> createResultDeserializer() {
        ObjectReader objectReader = ElasticsearchBulkAPI.defaultObjectMapper().addMixIn(BatchItemResult.class, DataStreamItemResultMixIn.class).readerFor(BatchResult.class);
        return new JacksonDeserializer(objectReader);
    }
}

