/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.ahc;

import com.fasterxml.jackson.databind.ObjectWriter;
import org.apache.logging.log4j.core.config.ConfigurationException;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.appenders.log4j2.elasticsearch.Deserializer;
import org.appenders.log4j2.elasticsearch.JacksonDeserializer;
import org.appenders.log4j2.elasticsearch.JacksonSerializer;
import org.appenders.log4j2.elasticsearch.Serializer;
import org.appenders.log4j2.elasticsearch.ahc.BatchItemResult;
import org.appenders.log4j2.elasticsearch.ahc.BatchResult;
import org.appenders.log4j2.elasticsearch.ahc.DataStreamItemMixIn;
import org.appenders.log4j2.elasticsearch.ahc.DataStreamItemResultMixIn;
import org.appenders.log4j2.elasticsearch.ahc.ElasticsearchBulkAPI;
import org.appenders.log4j2.elasticsearch.ahc.ElasticsearchDataStreamAPI;
import org.appenders.log4j2.elasticsearch.ahc.IndexRequest;

@Plugin(name="ElasticsearchDataStream", category="Core", elementType="clientAPIFactory", printObject=true)
public class ElasticsearchDataStreamAPIPlugin
extends ElasticsearchDataStreamAPI {
    private ElasticsearchDataStreamAPIPlugin(Serializer<Object> serializer, Deserializer<BatchResult> deserializer, String filterPath) {
        super(serializer, deserializer, filterPath);
    }

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder
    implements org.apache.logging.log4j.core.util.Builder<ElasticsearchDataStreamAPIPlugin> {
        @PluginAttribute(value="filterPath")
        protected String filterPath;
        private Serializer<Object> itemSerializer = this.createItemSerializer();
        private Deserializer<BatchResult> resultDeserializer = this.createResultDeserializer();

        public ElasticsearchDataStreamAPIPlugin build() {
            if (this.itemSerializer == null) {
                throw new ConfigurationException("itemSerializer cannot be null");
            }
            if (this.resultDeserializer == null) {
                throw new ConfigurationException("resultDeserializer cannot be null");
            }
            return new ElasticsearchDataStreamAPIPlugin(this.itemSerializer, this.resultDeserializer, this.filterPath);
        }

        protected Serializer<Object> createItemSerializer() {
            ObjectWriter objectWriter = ElasticsearchBulkAPI.defaultObjectMapper().addMixIn(IndexRequest.class, DataStreamItemMixIn.class).writerFor(IndexRequest.class);
            return new JacksonSerializer(objectWriter);
        }

        protected Deserializer<BatchResult> createResultDeserializer() {
            return new JacksonDeserializer(ElasticsearchBulkAPI.defaultObjectMapper().addMixIn(BatchItemResult.class, DataStreamItemResultMixIn.class).readerFor(BatchResult.class));
        }

        public Builder withItemSerializer(Serializer<Object> itemSerializer) {
            this.itemSerializer = itemSerializer;
            return this;
        }

        public Builder withResultDeserializer(Deserializer<BatchResult> resultDeserializer) {
            this.resultDeserializer = resultDeserializer;
            return this;
        }

        public Builder withFilterPath(String filterPath) {
            this.filterPath = filterPath;
            return this;
        }
    }
}

