/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.ahc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.appenders.core.logging.InternalLogging;
import org.appenders.log4j2.elasticsearch.LifeCycle;
import org.appenders.log4j2.elasticsearch.ahc.AHCResultCallback;
import org.appenders.log4j2.elasticsearch.ahc.BlockingResponseHandler;
import org.appenders.log4j2.elasticsearch.ahc.Request;
import org.appenders.log4j2.elasticsearch.ahc.RequestFactory;
import org.appenders.log4j2.elasticsearch.ahc.Response;
import org.appenders.log4j2.elasticsearch.ahc.ResponseHandler;
import org.appenders.log4j2.elasticsearch.ahc.ServerPool;
import org.appenders.log4j2.elasticsearch.metrics.DefaultMetricsFactory;
import org.appenders.log4j2.elasticsearch.metrics.Measured;
import org.appenders.log4j2.elasticsearch.metrics.Metric;
import org.appenders.log4j2.elasticsearch.metrics.MetricConfig;
import org.appenders.log4j2.elasticsearch.metrics.MetricConfigFactory;
import org.appenders.log4j2.elasticsearch.metrics.MetricType;
import org.appenders.log4j2.elasticsearch.metrics.Metrics;
import org.appenders.log4j2.elasticsearch.metrics.MetricsFactory;
import org.appenders.log4j2.elasticsearch.metrics.MetricsRegistry;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.RequestBuilder;

public class HttpClient
implements LifeCycle,
Measured {
    private volatile LifeCycle.State state = LifeCycle.State.STOPPED;
    private final AsyncHttpClient asyncClient;
    private final ServerPool serverPool;
    private final RequestFactory httpRequestFactory;
    private final HttpClientMetrics metrics;

    public HttpClient(AsyncHttpClient asyncClient, ServerPool serverPool, RequestFactory requestFactory) {
        this(HttpClient.class.getSimpleName(), (MetricsFactory)new DefaultMetricsFactory(Collections.emptyList()), asyncClient, serverPool, requestFactory);
    }

    public HttpClient(String name, MetricsFactory metricsFactory, AsyncHttpClient asyncClient, ServerPool serverPool, RequestFactory requestFactory) {
        this.asyncClient = asyncClient;
        this.serverPool = serverPool;
        this.httpRequestFactory = requestFactory;
        this.metrics = new HttpClientMetrics(name == null ? HttpClient.class.getSimpleName() : name, metricsFactory);
    }

    public static List<MetricConfig> metricConfigs(boolean enabled) {
        return Arrays.asList(MetricConfigFactory.createSuppliedConfig((MetricType)MetricType.COUNT, (boolean)enabled, (String)"connectionsActive"), MetricConfigFactory.createSuppliedConfig((MetricType)MetricType.COUNT, (boolean)enabled, (String)"connectionsIdle"), MetricConfigFactory.createSuppliedConfig((MetricType)MetricType.COUNT, (boolean)enabled, (String)"connectionsTotal"));
    }

    public <T extends Response> T execute(Request clientRequest, BlockingResponseHandler<T> responseHandler) {
        this.executeAsync(clientRequest, responseHandler);
        return responseHandler.getResult();
    }

    public <T extends Response> void executeAsync(Request request, ResponseHandler<T> responseHandler) {
        RequestBuilder clientRequest;
        try {
            clientRequest = this.createClientRequest(request);
        }
        catch (Exception e) {
            responseHandler.failed(e);
            return;
        }
        this.getAsyncClient().executeRequest(clientRequest, this.createCallback(responseHandler));
    }

    RequestBuilder createClientRequest(Request request) throws Exception {
        String url = this.serverPool.getNext() + '/' + request.getURI();
        return (RequestBuilder)this.httpRequestFactory.create(url, request);
    }

    <T extends Response> AsyncHandler<T> createCallback(ResponseHandler<T> responseHandler) {
        return new AHCResultCallback<T>(responseHandler);
    }

    public AsyncHttpClient getAsyncClient() {
        return this.asyncClient;
    }

    public void start() {
        if (this.isStarted()) {
            return;
        }
        this.state = LifeCycle.State.STARTED;
        InternalLogging.getLogger().debug("{}: Started", new Object[]{HttpClient.class.getSimpleName()});
    }

    public void stop() {
        if (this.isStopped()) {
            return;
        }
        InternalLogging.getLogger().debug("{}: Stopping client", new Object[]{HttpClient.class.getSimpleName()});
        if (!this.asyncClient.isClosed()) {
            try {
                this.asyncClient.close();
            }
            catch (IOException e) {
                InternalLogging.getLogger().warn("Async client might not have been stopped properly. Cause: " + e.getMessage(), new Object[0]);
            }
        }
        this.state = LifeCycle.State.STOPPED;
        InternalLogging.getLogger().debug("{}: Stopping client", new Object[]{HttpClient.class.getSimpleName()});
    }

    public boolean isStarted() {
        return this.state == LifeCycle.State.STARTED;
    }

    public boolean isStopped() {
        return this.state == LifeCycle.State.STOPPED;
    }

    public void register(MetricsRegistry registry) {
        this.metrics.register(registry);
    }

    public void deregister() {
        this.metrics.deregister();
    }

    public class HttpClientMetrics
    implements Metrics {
        private final List<MetricsRegistry.Registration> registrations = new ArrayList<MetricsRegistry.Registration>();
        private final Metric connectionsTotal;
        private final Metric connectionsActive;
        private final Metric connectionsIdle;

        private HttpClientMetrics(String name, MetricsFactory metricsFactory) {
            this.connectionsActive = metricsFactory.createMetric(name, "connectionsActive", () -> HttpClient.this.asyncClient.getClientStats().getTotalActiveConnectionCount());
            this.connectionsIdle = metricsFactory.createMetric(name, "connectionsIdle", () -> HttpClient.this.asyncClient.getClientStats().getTotalIdleConnectionCount());
            this.connectionsTotal = metricsFactory.createMetric(name, "connectionsTotal", () -> HttpClient.this.asyncClient.getClientStats().getTotalConnectionCount());
        }

        public void register(MetricsRegistry registry) {
            this.registrations.add(registry.register(this.connectionsActive));
            this.registrations.add(registry.register(this.connectionsIdle));
            this.registrations.add(registry.register(this.connectionsTotal));
        }

        public void deregister() {
            this.registrations.forEach(MetricsRegistry.Registration::deregister);
            this.registrations.clear();
        }
    }
}

