/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.ahc;

import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.appenders.log4j2.elasticsearch.Auth;
import org.appenders.log4j2.elasticsearch.ahc.AHCRequestFactory;
import org.appenders.log4j2.elasticsearch.ahc.HttpClient;
import org.appenders.log4j2.elasticsearch.ahc.RequestFactory;
import org.appenders.log4j2.elasticsearch.ahc.ServerPool;
import org.appenders.log4j2.elasticsearch.ahc.discovery.ServiceDiscovery;
import org.appenders.log4j2.elasticsearch.metrics.DefaultMetricsFactory;
import org.appenders.log4j2.elasticsearch.metrics.MetricConfig;
import org.appenders.log4j2.elasticsearch.metrics.MetricsFactory;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.DefaultAsyncHttpClient;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.asynchttpclient.Realm;
import org.asynchttpclient.SslEngineFactory;

public class HttpClientFactory {
    protected final Collection<String> serverList;
    protected final int connTimeout;
    protected final int readTimeout;
    protected final int maxTotalConnections;
    protected final int ioThreadCount;
    protected final boolean gzipCompression;
    protected final Realm realm;
    protected final SslEngineFactory sslEngineFactory;
    protected final ServiceDiscovery serviceDiscovery;
    protected final String name;
    protected final MetricsFactory metricsFactory;

    HttpClientFactory(Builder httpClientFactoryBuilder) {
        this.serverList = httpClientFactoryBuilder.serverList;
        this.connTimeout = httpClientFactoryBuilder.connTimeout;
        this.readTimeout = httpClientFactoryBuilder.readTimeout;
        this.maxTotalConnections = httpClientFactoryBuilder.maxTotalConnections;
        this.ioThreadCount = httpClientFactoryBuilder.ioThreadCount;
        this.gzipCompression = httpClientFactoryBuilder.gzipCompression;
        this.realm = httpClientFactoryBuilder.realm;
        this.sslEngineFactory = httpClientFactoryBuilder.sslEngineFactory;
        this.serviceDiscovery = httpClientFactoryBuilder.serviceDiscovery;
        this.metricsFactory = httpClientFactoryBuilder.metricsFactory;
        this.name = httpClientFactoryBuilder.name;
    }

    public HttpClient createInstance() {
        AsyncHttpClient asyncHttpClient = this.createAsyncHttpClient();
        ServerPool serverPool = new ServerPool(new ArrayList<String>(this.serverList));
        if (this.serviceDiscovery != null) {
            this.serviceDiscovery.addListener(serverPool);
        }
        return this.createConfiguredClient(asyncHttpClient, serverPool);
    }

    protected HttpClient createConfiguredClient(AsyncHttpClient asyncHttpClient, ServerPool serverPool) {
        return this.createConfiguredClient(asyncHttpClient, serverPool, this.createRequestFactory());
    }

    protected HttpClient createConfiguredClient(AsyncHttpClient asyncHttpClient, ServerPool serverPool, RequestFactory requestFactory) {
        return new HttpClient(this.name, this.metricsFactory, asyncHttpClient, serverPool, requestFactory);
    }

    protected RequestFactory createRequestFactory() {
        return new AHCRequestFactory();
    }

    protected AsyncHttpClient createAsyncHttpClient() {
        DefaultAsyncHttpClientConfig.Builder builder = new DefaultAsyncHttpClientConfig.Builder();
        builder.setIoThreadsCount(this.ioThreadCount).setConnectTimeout(this.connTimeout).setAllocator((ByteBufAllocator)PooledByteBufAllocator.DEFAULT).setMaxConnections(this.maxTotalConnections).setReadTimeout(this.readTimeout).setCompressionEnforced(this.gzipCompression).setRealm(this.realm).setSslEngineFactory(this.sslEngineFactory);
        return new DefaultAsyncHttpClient((AsyncHttpClientConfig)builder.build());
    }

    public static class Builder {
        protected Collection<String> serverList = new ArrayList<String>();
        protected int connTimeout = 1000;
        protected int readTimeout = 1000;
        protected int maxTotalConnections;
        protected int ioThreadCount = this.maxTotalConnections = 1;
        protected Auth<Builder> auth;
        protected ServiceDiscovery serviceDiscovery;
        protected final MetricsFactory metricsFactory = new DefaultMetricsFactory(HttpClient.metricConfigs(false));
        protected String name;
        protected boolean gzipCompression;
        protected Realm realm;
        protected SslEngineFactory sslEngineFactory;

        public HttpClientFactory build() {
            return new HttpClientFactory(this.lazyInit());
        }

        protected Builder lazyInit() {
            if (this.auth != null) {
                this.auth.configure((Object)this);
            }
            return this;
        }

        public Builder withServerList(Collection<String> serverList) {
            this.serverList = serverList;
            return this;
        }

        public Builder withConnTimeout(int connTimeout) {
            this.connTimeout = connTimeout;
            return this;
        }

        public Builder withReadTimeout(int readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        public Builder withMaxTotalConnections(int maxTotalConnections) {
            this.maxTotalConnections = maxTotalConnections;
            return this;
        }

        public Builder withIoThreadCount(int ioThreadCount) {
            this.ioThreadCount = ioThreadCount;
            return this;
        }

        public Builder withAuth(Auth<Builder> auth) {
            this.auth = auth;
            return this;
        }

        public Builder withGzipCompression(boolean gzipCompression) {
            this.gzipCompression = gzipCompression;
            return this;
        }

        public Builder withRealm(Realm realm) {
            this.realm = realm;
            return this;
        }

        public Builder withSslEngineFactory(SslEngineFactory sslSocketFactory) {
            this.sslEngineFactory = sslSocketFactory;
            return this;
        }

        public Builder withServiceDiscovery(ServiceDiscovery serviceDiscovery) {
            this.serviceDiscovery = serviceDiscovery;
            return this;
        }

        public Builder withMetricConfigs(List<MetricConfig> metricConfigs) {
            this.metricsFactory.configure(metricConfigs);
            return this;
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public String toString() {
            return "Builder{serverList=" + this.serverList + ", connTimeout=" + this.connTimeout + ", readTimeout=" + this.readTimeout + ", maxTotalConnections=" + this.maxTotalConnections + ", ioThreadCount=" + this.ioThreadCount + ", auth=" + (this.auth != null) + ", serviceDiscovery=" + (this.serviceDiscovery != null) + ", metrics=" + this.metricsFactory.getMetricConfigs().size() + ", name='" + this.name + '\'' + '}';
        }
    }
}

