/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.ahc;

import java.util.concurrent.atomic.AtomicReference;
import org.appenders.core.logging.InternalLogging;
import org.appenders.log4j2.elasticsearch.ClientProvider;
import org.appenders.log4j2.elasticsearch.LifeCycle;
import org.appenders.log4j2.elasticsearch.ahc.HttpClient;
import org.appenders.log4j2.elasticsearch.ahc.HttpClientFactory;
import org.appenders.log4j2.elasticsearch.ahc.discovery.ServiceDiscovery;
import org.appenders.log4j2.elasticsearch.metrics.Measured;
import org.appenders.log4j2.elasticsearch.metrics.MetricsRegistry;

public class HttpClientProvider
implements ClientProvider<HttpClient>,
LifeCycle,
Measured {
    private volatile LifeCycle.State state = LifeCycle.State.STOPPED;
    private final HttpClientFactory.Builder httpClientFactoryBuilder;
    private final AtomicReference<HttpClient> httpClient = new AtomicReference<Object>(null);

    public HttpClientProvider(HttpClientFactory.Builder httpClientFactoryBuilder) {
        this.httpClientFactoryBuilder = httpClientFactoryBuilder;
    }

    public HttpClient createClient() {
        if (this.httpClient.get() == null) {
            this.httpClient.set(this.httpClientFactoryBuilder.build().createInstance());
        }
        return this.httpClient.get();
    }

    public HttpClientFactory.Builder getHttpClientFactoryBuilder() {
        return this.httpClientFactoryBuilder;
    }

    public void start() {
        HttpClient httpClient;
        if (!LifeCycle.of((Object)this.getHttpClientFactoryBuilder().serviceDiscovery).isStarted()) {
            LifeCycle.of((Object)this.getHttpClientFactoryBuilder().serviceDiscovery).start();
        }
        if ((httpClient = this.createClient()).isStarted()) {
            InternalLogging.getLogger().debug("{}: HTTP client already started", new Object[]{HttpClient.class.getSimpleName()});
        } else {
            InternalLogging.getLogger().debug("{}: Starting HTTP client", new Object[]{HttpClient.class.getSimpleName()});
            httpClient.start();
        }
        this.state = LifeCycle.State.STARTED;
    }

    public void stop() {
        if (this.isStopped()) {
            return;
        }
        ServiceDiscovery serviceDiscovery = this.getHttpClientFactoryBuilder().serviceDiscovery;
        Measured.of((Object)serviceDiscovery).deregister();
        LifeCycle.of((Object)serviceDiscovery).stop();
        Measured.of((Object)this.httpClient.get()).deregister();
        LifeCycle.of((Object)this.httpClient.get()).stop();
        this.httpClient.set(null);
        this.state = LifeCycle.State.STOPPED;
    }

    public boolean isStarted() {
        return this.state == LifeCycle.State.STARTED;
    }

    public boolean isStopped() {
        return this.state == LifeCycle.State.STOPPED;
    }

    public void register(MetricsRegistry registry) {
        if (this.httpClient.get() == null) {
            InternalLogging.getLogger().warn("{}: Metrics not ready. HttpClient not created yet", new Object[]{HttpClientProvider.class.getSimpleName()});
            return;
        }
        this.httpClient.get().register(registry);
    }

    public void deregister() {
        Measured.of((Object)this.httpClient.get()).deregister();
    }

    public String toString() {
        return "HttpClientProvider{config=" + this.httpClientFactoryBuilder + '}';
    }
}

