/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.ahc;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import org.appenders.log4j2.elasticsearch.EmptyItemSourceFactory;
import org.appenders.log4j2.elasticsearch.ILMPolicy;
import org.appenders.log4j2.elasticsearch.ItemSource;
import org.appenders.log4j2.elasticsearch.OpSource;
import org.appenders.log4j2.elasticsearch.Operation;
import org.appenders.log4j2.elasticsearch.OperationFactory;
import org.appenders.log4j2.elasticsearch.SetupStep;
import org.appenders.log4j2.elasticsearch.SkippingSetupStepChain;
import org.appenders.log4j2.elasticsearch.StepProcessor;
import org.appenders.log4j2.elasticsearch.ValueResolver;
import org.appenders.log4j2.elasticsearch.ahc.ByteBufItemSourceWriter;
import org.appenders.log4j2.elasticsearch.ahc.CheckBootstrapIndex;
import org.appenders.log4j2.elasticsearch.ahc.CreateBootstrapIndex;
import org.appenders.log4j2.elasticsearch.ahc.PutILMPolicy;
import org.appenders.log4j2.elasticsearch.ahc.Request;
import org.appenders.log4j2.elasticsearch.ahc.Response;

public class ILMPolicySetupOp
implements OperationFactory {
    protected final StepProcessor<SetupStep<Request, Response>> stepProcessor;
    protected final ValueResolver valueResolver;
    protected final EmptyItemSourceFactory itemSourceFactory;
    private final ByteBufItemSourceWriter writer = new ByteBufItemSourceWriter();

    public ILMPolicySetupOp(StepProcessor<SetupStep<Request, Response>> stepProcessor, ValueResolver valueResolver, EmptyItemSourceFactory itemSourceFactory) {
        this.stepProcessor = stepProcessor;
        this.valueResolver = valueResolver;
        this.itemSourceFactory = itemSourceFactory;
    }

    public <T extends OpSource> Operation create(T opSource) {
        ILMPolicy ilmPolicy = (ILMPolicy)opSource;
        ArrayList<SetupStep> setupSteps = new ArrayList<SetupStep>();
        if (ilmPolicy.isCreateBootstrapIndex()) {
            CheckBootstrapIndex checkBootstrapIndex = new CheckBootstrapIndex(ilmPolicy.getRolloverAlias());
            String bootstrapIndexRequestBody = String.format("{\"aliases\": {\"%s\":{\"is_write_index\":true}}}", ilmPolicy.getRolloverAlias());
            CreateBootstrapIndex createBootstrapIndex = new CreateBootstrapIndex(ilmPolicy.getRolloverAlias(), this.writer.write((ItemSource<ByteBuf>)this.itemSourceFactory.createEmptySource(), bootstrapIndexRequestBody.getBytes()));
            setupSteps.add(checkBootstrapIndex);
            setupSteps.add(createBootstrapIndex);
        }
        String ilmPolicyRequestBody = this.valueResolver.resolve(ilmPolicy.getSource());
        PutILMPolicy updateIlmPolicy = new PutILMPolicy(ilmPolicy.getName(), this.writer.write((ItemSource<ByteBuf>)this.itemSourceFactory.createEmptySource(), ilmPolicyRequestBody.getBytes()));
        setupSteps.add(updateIlmPolicy);
        return new SkippingSetupStepChain(setupSteps, this.stepProcessor);
    }
}

