/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.ahc;

import io.netty.buffer.ByteBuf;
import org.appenders.log4j2.elasticsearch.ItemSource;
import org.appenders.log4j2.elasticsearch.ahc.Item;

public class IndexRequest
implements Item<ItemSource<ByteBuf>> {
    protected final String id;
    protected final String type;
    protected final String index;
    protected final ItemSource<ByteBuf> source;

    protected IndexRequest(Builder builder) {
        this.id = builder.id;
        this.index = builder.index;
        this.type = builder.type;
        this.source = builder.source;
    }

    public String getId() {
        return this.id;
    }

    public String getIndex() {
        return this.index;
    }

    public String getType() {
        return this.type;
    }

    @Override
    public final ItemSource<ByteBuf> getSource() {
        return this.source;
    }

    @Override
    public void completed() {
        this.source.release();
    }

    public final boolean sameIndex(IndexRequest other) {
        return this.index.equals(other.index);
    }

    public final boolean sameType(IndexRequest other) {
        if (this.type == null) {
            return other.type == null;
        }
        return this.type.equals(other.type);
    }

    public static class Builder {
        private final ItemSource<ByteBuf> source;
        private String id;
        private String index;
        private String type;

        public Builder(ItemSource<ByteBuf> source) {
            this.source = source;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder index(String index) {
            this.index = index;
            return this;
        }

        public Builder type(String mappingType) {
            this.type = mappingType;
            return this;
        }

        public IndexRequest build() {
            this.validate();
            return new IndexRequest(this);
        }

        protected void validate() {
            if (this.source == null) {
                throw new IllegalArgumentException("source cannot be null");
            }
            if (this.index == null) {
                throw new IllegalArgumentException("index cannot be null");
            }
        }
    }
}

