/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.ahc;

import io.netty.buffer.ByteBuf;
import java.util.Collections;
import org.appenders.log4j2.elasticsearch.EmptyItemSourceFactory;
import org.appenders.log4j2.elasticsearch.IndexTemplate;
import org.appenders.log4j2.elasticsearch.ItemSource;
import org.appenders.log4j2.elasticsearch.OpSource;
import org.appenders.log4j2.elasticsearch.Operation;
import org.appenders.log4j2.elasticsearch.OperationFactory;
import org.appenders.log4j2.elasticsearch.SetupStep;
import org.appenders.log4j2.elasticsearch.SkippingSetupStepChain;
import org.appenders.log4j2.elasticsearch.StepProcessor;
import org.appenders.log4j2.elasticsearch.ValueResolver;
import org.appenders.log4j2.elasticsearch.ahc.ByteBufItemSourceWriter;
import org.appenders.log4j2.elasticsearch.ahc.PutIndexTemplate;
import org.appenders.log4j2.elasticsearch.ahc.Request;
import org.appenders.log4j2.elasticsearch.ahc.Response;

public class IndexTemplateSetupOp
implements OperationFactory {
    protected final StepProcessor<SetupStep<Request, Response>> stepProcessor;
    protected final ValueResolver valueResolver;
    protected final EmptyItemSourceFactory itemSourceFactory;
    private final ByteBufItemSourceWriter writer = new ByteBufItemSourceWriter();

    public IndexTemplateSetupOp(StepProcessor<SetupStep<Request, Response>> stepProcessor, ValueResolver valueResolver, EmptyItemSourceFactory itemSourceFactory) {
        this.stepProcessor = stepProcessor;
        this.valueResolver = valueResolver;
        this.itemSourceFactory = itemSourceFactory;
    }

    public <T extends OpSource> Operation create(T opSource) {
        IndexTemplate indexTemplate = (IndexTemplate)opSource;
        ItemSource emptySource = this.itemSourceFactory.createEmptySource();
        PutIndexTemplate putIndexTemplate = new PutIndexTemplate(indexTemplate.getApiVersion(), indexTemplate.getName(), this.writer.write((ItemSource<ByteBuf>)emptySource, this.valueResolver.resolve(indexTemplate.getSource()).getBytes()));
        return new SkippingSetupStepChain(Collections.singletonList(putIndexTemplate), this.stepProcessor);
    }
}

