/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.ahc;

import org.apache.logging.log4j.core.config.ConfigurationException;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.appenders.log4j2.elasticsearch.CertInfo;
import org.appenders.log4j2.elasticsearch.ahc.HttpClientFactory;
import org.appenders.log4j2.elasticsearch.ahc.JKSCertInfo;

@Plugin(name="JKS", category="Core", elementType="certInfo")
public class JKSCertInfoPlugin
implements CertInfo<HttpClientFactory.Builder> {
    static final String PLUGIN_NAME = "JKS";
    private final JKSCertInfo delegate;

    protected JKSCertInfoPlugin(String keystorePath, String keystorePassword, String truststorePath, String truststorePassword) {
        this.delegate = new JKSCertInfo(keystorePath, keystorePassword, truststorePath, truststorePassword);
    }

    public void applyTo(HttpClientFactory.Builder builder) {
        try {
            this.delegate.applyTo(builder);
        }
        catch (IllegalArgumentException e) {
            throw new ConfigurationException(e.getMessage());
        }
    }

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder
    implements org.apache.logging.log4j.core.util.Builder<JKSCertInfoPlugin> {
        public static final String EMPTY_PASSWORD = "";
        @PluginBuilderAttribute
        private String keystorePath;
        @PluginBuilderAttribute
        private String keystorePassword = "";
        @PluginBuilderAttribute
        private String truststorePath;
        @PluginBuilderAttribute
        private String truststorePassword = "";

        public JKSCertInfoPlugin build() {
            if (this.keystorePath == null) {
                throw new ConfigurationException("No keystorePath provided for JKS");
            }
            if (this.keystorePassword == null) {
                throw new ConfigurationException("No keystorePassword provided for JKS");
            }
            if (this.truststorePath == null) {
                throw new ConfigurationException("No truststorePath provided for JKS");
            }
            if (this.truststorePassword == null) {
                throw new ConfigurationException("No truststorePassword provided for JKS");
            }
            return new JKSCertInfoPlugin(this.keystorePath, this.keystorePassword, this.truststorePath, this.truststorePassword);
        }

        public Builder withKeystorePath(String keystorePath) {
            this.keystorePath = keystorePath;
            return this;
        }

        public Builder withKeystorePassword(String keystorePassword) {
            this.keystorePassword = keystorePassword;
            return this;
        }

        public Builder withTruststorePath(String truststorePath) {
            this.truststorePath = truststorePath;
            return this;
        }

        public Builder withTruststorePassword(String truststorePassword) {
            this.truststorePassword = truststorePassword;
            return this;
        }
    }
}

