/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.ahc;

import org.appenders.core.logging.InternalLogging;
import org.appenders.log4j2.elasticsearch.ItemSource;
import org.appenders.log4j2.elasticsearch.Result;
import org.appenders.log4j2.elasticsearch.SetupStep;
import org.appenders.log4j2.elasticsearch.ahc.GenericRequest;
import org.appenders.log4j2.elasticsearch.ahc.Request;
import org.appenders.log4j2.elasticsearch.ahc.Response;

public class PutILMPolicy
extends SetupStep<Request, Response> {
    protected final String name;
    protected final ItemSource source;

    public PutILMPolicy(String name, ItemSource source) {
        this.name = name;
        this.source = source;
    }

    public Result onResponse(Response response) {
        this.source.release();
        if (response.getResponseCode() == 200) {
            InternalLogging.getLogger().info("{}: ILM policy {} updated", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), this.name});
            return Result.SUCCESS;
        }
        InternalLogging.getLogger().error("{}: Unable to update ILM policy: {}", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), response.getErrorMessage()});
        return Result.FAILURE;
    }

    public Request createRequest() {
        String uri = String.format("_ilm/policy/%s", this.name);
        return new GenericRequest("PUT", uri, this.source);
    }
}

