/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.ahc;

import org.appenders.log4j2.elasticsearch.Auth;
import org.appenders.log4j2.elasticsearch.CertInfo;
import org.appenders.log4j2.elasticsearch.Credentials;
import org.appenders.log4j2.elasticsearch.ahc.HttpClientFactory;

public class Security
implements Auth<HttpClientFactory.Builder> {
    private final Credentials<HttpClientFactory.Builder> credentials;
    private final CertInfo<HttpClientFactory.Builder> certInfo;

    protected Security(Credentials<HttpClientFactory.Builder> credentials, CertInfo<HttpClientFactory.Builder> certInfo) {
        this.credentials = credentials;
        this.certInfo = certInfo;
    }

    public void configure(HttpClientFactory.Builder builder) {
        this.credentials.applyTo((Object)builder);
        if (this.certInfo != null) {
            this.certInfo.applyTo((Object)builder);
        }
    }

    public static class Builder {
        private Credentials<HttpClientFactory.Builder> credentials;
        private CertInfo<HttpClientFactory.Builder> certInfo;

        public Security build() {
            if (this.credentials == null) {
                throw new IllegalArgumentException("No credentials provided for " + Security.class.getSimpleName());
            }
            return new Security(this.credentials, this.certInfo);
        }

        public Builder withCredentials(Credentials<HttpClientFactory.Builder> credentials) {
            this.credentials = credentials;
            return this;
        }

        public Builder withCertInfo(CertInfo<HttpClientFactory.Builder> certInfo) {
            this.certInfo = certInfo;
            return this;
        }
    }
}

