/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.ahc;

import java.util.function.Function;
import org.appenders.log4j2.elasticsearch.Deserializer;
import org.appenders.log4j2.elasticsearch.Result;
import org.appenders.log4j2.elasticsearch.SetupStep;
import org.appenders.log4j2.elasticsearch.StepProcessor;
import org.appenders.log4j2.elasticsearch.ahc.BatchResult;
import org.appenders.log4j2.elasticsearch.ahc.BlockingResponseHandler;
import org.appenders.log4j2.elasticsearch.ahc.HttpClientProvider;
import org.appenders.log4j2.elasticsearch.ahc.Request;
import org.appenders.log4j2.elasticsearch.ahc.Response;

public class SyncStepProcessor
implements StepProcessor<SetupStep<Request, Response>> {
    private final HttpClientProvider clientProvider;
    private final Deserializer<BatchResult> deserializer;

    public SyncStepProcessor(HttpClientProvider clientProvider, Deserializer<BatchResult> deserializer) {
        this.deserializer = deserializer;
        this.clientProvider = clientProvider;
    }

    public Result process(SetupStep<Request, Response> setupStep) {
        BatchResult response = this.clientProvider.createClient().execute((Request)setupStep.createRequest(), this.createBlockingResponseHandler());
        return setupStep.onResponse((Object)response);
    }

    final BlockingResponseHandler<BatchResult> createBlockingResponseHandler() {
        return new BlockingResponseHandler<BatchResult>(this.deserializer, this.createBlockingResponseFallbackHandler());
    }

    final Function<Exception, BatchResult> createBlockingResponseFallbackHandler() {
        return ex -> {
            BatchResult basicResponse = new BatchResult(0, false, null, 500, null);
            if (ex != null) {
                basicResponse.withErrorMessage(ex.getMessage());
            }
            return basicResponse;
        };
    }
}

