/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.ahc.discovery;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.appenders.log4j2.elasticsearch.ahc.BlockingResponseHandler;
import org.appenders.log4j2.elasticsearch.ahc.ElasticsearchBulkAPI;
import org.appenders.log4j2.elasticsearch.ahc.GenericRequest;
import org.appenders.log4j2.elasticsearch.ahc.HttpClient;
import org.appenders.log4j2.elasticsearch.ahc.discovery.NodeInfo;
import org.appenders.log4j2.elasticsearch.ahc.discovery.NodesResponse;
import org.appenders.log4j2.elasticsearch.ahc.discovery.ServiceDiscoveryCallback;
import org.appenders.log4j2.elasticsearch.ahc.discovery.ServiceDiscoveryRequest;

public class ElasticsearchNodesQuery
implements ServiceDiscoveryRequest<HttpClient> {
    public static final String DEFAULT_NODES_FILTER = "_all";
    private final BlockingResponseHandler<NodesResponse> responseHandler = new BlockingResponseHandler<NodesResponse>(ElasticsearchBulkAPI.defaultObjectMapper().readerFor(NodesResponse.class), ex -> new NodesResponse(Collections.emptyMap()).withErrorMessage("Unable to refresh server list: " + ex.getMessage()));
    protected final String resultScheme;
    protected final String nodesFilter;

    public ElasticsearchNodesQuery(String resultScheme) {
        this(resultScheme, DEFAULT_NODES_FILTER);
    }

    public ElasticsearchNodesQuery(String resultScheme, String nodesFilter) {
        this.resultScheme = resultScheme;
        this.nodesFilter = nodesFilter;
    }

    @Override
    public void execute(HttpClient httpClient, ServiceDiscoveryCallback<List<String>> callback) {
        NodesResponse response;
        GenericRequest request = new GenericRequest("GET", String.format("_nodes/%s/http", this.nodesFilter), null);
        try {
            response = httpClient.execute(request, this.responseHandler);
        }
        catch (Exception e) {
            callback.onFailure(e);
            return;
        }
        if (response.isSucceeded()) {
            callback.onSuccess(response.getNodes().values().stream().map(this::formatAddress).collect(Collectors.toList()));
        } else {
            callback.onSuccess(Collections.emptyList());
        }
    }

    protected String formatAddress(NodeInfo info) {
        return String.format("%s://%s", this.resultScheme, info.getHttpPublishAddress().getPublishAddress());
    }
}

