/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.hc;

import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.appenders.log4j2.elasticsearch.Credentials;
import org.appenders.log4j2.elasticsearch.hc.HttpClientFactory;

public final class BasicCredentials
implements Credentials<HttpClientFactory.Builder> {
    static final String PLUGIN_NAME = "BasicCredentials";
    private final String username;
    private final String password;

    public BasicCredentials(String username, String password) {
        this.username = username;
        this.password = password;
    }

    public void applyTo(HttpClientFactory.Builder builder) {
        BasicCredentialsProvider basicCredentialsProvider = new BasicCredentialsProvider();
        basicCredentialsProvider.setCredentials(AuthScope.ANY, (org.apache.http.auth.Credentials)new UsernamePasswordCredentials(this.username, this.password));
        builder.withDefaultCredentialsProvider((CredentialsProvider)basicCredentialsProvider);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String username;
        private String password;

        public BasicCredentials build() {
            if (this.username == null) {
                throw new IllegalArgumentException("No username provided for BasicCredentials");
            }
            if (this.password == null) {
                throw new IllegalArgumentException("No password provided for BasicCredentials");
            }
            return new BasicCredentials(this.username, this.password);
        }

        public Builder withUsername(String username) {
            this.username = username;
            return this;
        }

        public Builder withPassword(String password) {
            this.password = password;
            return this;
        }
    }
}

