/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.hc;

import org.apache.logging.log4j.core.config.ConfigurationException;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;
import org.appenders.log4j2.elasticsearch.Credentials;
import org.appenders.log4j2.elasticsearch.hc.BasicCredentials;
import org.appenders.log4j2.elasticsearch.hc.HttpClientFactory;

@Plugin(name="BasicCredentials", category="Core", elementType="credentials")
public final class BasicCredentialsPlugin
implements Credentials<HttpClientFactory.Builder> {
    static final String PLUGIN_NAME = "BasicCredentials";
    private final BasicCredentials delegate;

    protected BasicCredentialsPlugin(String username, String password) {
        this.delegate = new BasicCredentials(username, password);
    }

    public void applyTo(HttpClientFactory.Builder settings) {
        this.delegate.applyTo(settings);
    }

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder
    implements org.apache.logging.log4j.core.util.Builder<BasicCredentialsPlugin> {
        @PluginBuilderAttribute
        @Required(message="No username provided for BasicCredentials")
        private String username;
        @PluginBuilderAttribute
        @Required(message="No password provided for BasicCredentials")
        private String password;

        public BasicCredentialsPlugin build() {
            if (this.username == null) {
                throw new ConfigurationException("No username provided for BasicCredentials");
            }
            if (this.password == null) {
                throw new ConfigurationException("No password provided for BasicCredentials");
            }
            return new BasicCredentialsPlugin(this.username, this.password);
        }

        public Builder withUsername(String username) {
            this.username = username;
            return this;
        }

        public Builder withPassword(String password) {
            this.password = password;
            return this;
        }
    }
}

