/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.hc;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import org.appenders.log4j2.elasticsearch.hc.BatchItemResult;
import org.appenders.log4j2.elasticsearch.hc.BatchResult;
import org.appenders.log4j2.elasticsearch.hc.Error;

public class BatchResultDeserializer
extends JsonDeserializer {
    public Object deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        String fieldName;
        int took = 0;
        boolean errors = false;
        Error error = null;
        int status = -1;
        ArrayList<BatchItemResult> items = null;
        while ((fieldName = p.nextFieldName()) != null) {
            switch (fieldName) {
                case "took": {
                    took = p.nextIntValue(-1);
                    break;
                }
                case "errors": {
                    errors = p.nextBooleanValue();
                    break;
                }
                case "status": {
                    status = p.nextIntValue(-1);
                    break;
                }
                case "error": {
                    p.nextValue();
                    JsonDeserializer typeDeserializer = ctxt.findNonContextualValueDeserializer(ctxt.constructType(Error.class));
                    error = (Error)typeDeserializer.deserialize(p, ctxt);
                    break;
                }
                case "items": {
                    if (!errors) break;
                    items = new ArrayList<BatchItemResult>();
                    p.nextValue();
                    p.nextValue();
                    ObjectMapper mapper = (ObjectMapper)p.getCodec();
                    MappingIterator batchResultItemMappingIterator = mapper.readValues(p, BatchItemResult.class);
                    while (batchResultItemMappingIterator.hasNext()) {
                        items.add((BatchItemResult)batchResultItemMappingIterator.next());
                    }
                    break;
                }
            }
        }
        return new BatchResult(took, errors, error, status, items);
    }
}

