/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.hc;

import com.fasterxml.jackson.databind.ObjectReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.CountDownLatch;
import java.util.function.Function;
import org.appenders.log4j2.elasticsearch.Deserializer;
import org.appenders.log4j2.elasticsearch.JacksonDeserializer;
import org.appenders.log4j2.elasticsearch.hc.Response;
import org.appenders.log4j2.elasticsearch.hc.ResponseHandler;

public class BlockingResponseHandler<T extends Response>
implements ResponseHandler<T> {
    protected final CountDownLatch countDownLatch = new CountDownLatch(1);
    protected final Function<Exception, T> fallbackResponseTemplate;
    protected final Deserializer<T> deserializer;
    protected T result;

    public BlockingResponseHandler(Deserializer<T> deserializer, Function<Exception, T> fallbackResponseTemplate) {
        this.deserializer = deserializer;
        this.fallbackResponseTemplate = fallbackResponseTemplate;
    }

    @Deprecated
    public BlockingResponseHandler(ObjectReader objectReader, Function<Exception, T> fallbackResponseTemplate) {
        this((Deserializer<T>)new JacksonDeserializer(objectReader), fallbackResponseTemplate);
    }

    @Override
    public final void completed(T result) {
        this.result = result;
        this.countDownLatch.countDown();
    }

    @Override
    public final void failed(Exception exception) {
        this.result = (Response)this.fallbackResponseTemplate.apply(exception);
        this.countDownLatch.countDown();
    }

    @Override
    public T deserializeResponse(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            return (T)((Response)this.fallbackResponseTemplate.apply(null));
        }
        return (T)((Response)this.deserializer.read(inputStream));
    }

    public T getResult() {
        try {
            this.countDownLatch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return this.result;
    }
}

