/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.hc;

import org.appenders.core.logging.InternalLogging;
import org.appenders.log4j2.elasticsearch.Result;
import org.appenders.log4j2.elasticsearch.SetupStep;
import org.appenders.log4j2.elasticsearch.hc.GenericRequest;
import org.appenders.log4j2.elasticsearch.hc.Request;
import org.appenders.log4j2.elasticsearch.hc.Response;

public class CheckDataStream
extends SetupStep<Request, Response> {
    protected final String name;

    public CheckDataStream(String name) {
        this.name = name;
    }

    public Result onResponse(Response response) {
        if (response.getResponseCode() == 404) {
            InternalLogging.getLogger().info("{}: Data stream {} does not exist", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), this.name});
            return Result.SUCCESS;
        }
        if (response.getResponseCode() == 200) {
            InternalLogging.getLogger().info("{}: Data stream {} already exists", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), this.name});
            return Result.SKIP;
        }
        InternalLogging.getLogger().error("{}: Unable to determine if {} data stream already exists", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), this.name});
        return Result.FAILURE;
    }

    public Request createRequest() {
        return new GenericRequest("GET", "_data_stream/" + this.name, null);
    }
}

