/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.hc;

import org.appenders.core.logging.InternalLogging;
import org.appenders.log4j2.elasticsearch.ItemSource;
import org.appenders.log4j2.elasticsearch.Result;
import org.appenders.log4j2.elasticsearch.SetupContext;
import org.appenders.log4j2.elasticsearch.SetupStep;
import org.appenders.log4j2.elasticsearch.hc.GenericRequest;
import org.appenders.log4j2.elasticsearch.hc.Request;
import org.appenders.log4j2.elasticsearch.hc.Response;

public class CreateBootstrapIndex
extends SetupStep<Request, Response> {
    static final String BOOTSTRAP_TEMPLATE = "{\"aliases\": {\"%s\":{\"is_write_index\":true}}}";
    protected final String rolloverAlias;
    protected final String bootstrapIndexName;
    protected final ItemSource itemSource;

    public CreateBootstrapIndex(String rolloverAlias, ItemSource itemSource) {
        this.rolloverAlias = rolloverAlias;
        this.bootstrapIndexName = String.format("%s-000001", rolloverAlias);
        this.itemSource = itemSource;
    }

    public boolean shouldProcess(SetupContext setupContext) {
        boolean shouldExecute = Result.SUCCESS.equals((Object)setupContext.getLatestResult());
        if (!shouldExecute) {
            InternalLogging.getLogger().info("{}: Skipping bootstrap index creation", new Object[]{((Object)((Object)this)).getClass().getSimpleName()});
        }
        return shouldExecute;
    }

    public Result onResponse(Response response) {
        if (response.getResponseCode() == 200) {
            InternalLogging.getLogger().info("{}: Bootstrap index {} created", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), this.bootstrapIndexName});
            return Result.SUCCESS;
        }
        InternalLogging.getLogger().error("{}: Unable to create bootstrap index: {}", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), response.getErrorMessage()});
        return Result.FAILURE;
    }

    public Request createRequest() {
        return new GenericRequest("PUT", this.bootstrapIndexName, this.itemSource);
    }
}

