/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.hc;

import org.appenders.core.logging.InternalLogging;
import org.appenders.log4j2.elasticsearch.ItemSource;
import org.appenders.log4j2.elasticsearch.Result;
import org.appenders.log4j2.elasticsearch.SetupContext;
import org.appenders.log4j2.elasticsearch.SetupStep;
import org.appenders.log4j2.elasticsearch.hc.GenericRequest;
import org.appenders.log4j2.elasticsearch.hc.Request;
import org.appenders.log4j2.elasticsearch.hc.Response;

public class CreateDataStream
extends SetupStep<Request, Response> {
    protected final String name;
    protected final ItemSource itemSource;

    public CreateDataStream(String name, ItemSource itemSource) {
        this.name = name;
        this.itemSource = itemSource;
    }

    public boolean shouldProcess(SetupContext setupContext) {
        boolean shouldExecute = Result.SUCCESS.equals((Object)setupContext.getLatestResult());
        if (!shouldExecute) {
            InternalLogging.getLogger().info("{}: Skipping data stream creation", new Object[]{((Object)((Object)this)).getClass().getSimpleName()});
        }
        return shouldExecute;
    }

    public Result onResponse(Response response) {
        if (response.getResponseCode() == 200) {
            InternalLogging.getLogger().info("{}: Data stream {} created", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), this.name});
            return Result.SUCCESS;
        }
        InternalLogging.getLogger().error("{}: Unable to create data stream: {}", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), response.getErrorMessage()});
        return Result.FAILURE;
    }

    public Request createRequest() {
        return new GenericRequest("PUT", "_data_stream/" + this.name, this.itemSource);
    }
}

