/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.hc;

import io.netty.buffer.UnpooledByteBufAllocator;
import org.appenders.log4j2.elasticsearch.ByteBufBoundedSizeLimitPolicy;
import org.appenders.log4j2.elasticsearch.ByteBufPooledObjectOps;
import org.appenders.log4j2.elasticsearch.EmptyItemSourceFactory;
import org.appenders.log4j2.elasticsearch.LifeCycle;
import org.appenders.log4j2.elasticsearch.OperationFactoryDispatcher;
import org.appenders.log4j2.elasticsearch.PooledItemSourceFactory;
import org.appenders.log4j2.elasticsearch.PooledObjectOps;
import org.appenders.log4j2.elasticsearch.ResizePolicy;
import org.appenders.log4j2.elasticsearch.SetupStep;
import org.appenders.log4j2.elasticsearch.SizeLimitPolicy;
import org.appenders.log4j2.elasticsearch.StepProcessor;
import org.appenders.log4j2.elasticsearch.UnlimitedResizePolicy;
import org.appenders.log4j2.elasticsearch.ValueResolver;
import org.appenders.log4j2.elasticsearch.hc.ComponentTemplateSetupOp;
import org.appenders.log4j2.elasticsearch.hc.DataStreamSetupOp;
import org.appenders.log4j2.elasticsearch.hc.ILMPolicySetupOp;
import org.appenders.log4j2.elasticsearch.hc.IndexTemplateSetupOp;
import org.appenders.log4j2.elasticsearch.hc.Request;
import org.appenders.log4j2.elasticsearch.hc.Response;

public class ElasticsearchOperationFactory
extends OperationFactoryDispatcher
implements LifeCycle {
    private volatile LifeCycle.State state = LifeCycle.State.STOPPED;
    private final EmptyItemSourceFactory itemSourceFactory;

    public ElasticsearchOperationFactory(StepProcessor<SetupStep<Request, Response>> stepProcessor, ValueResolver valueResolver, EmptyItemSourceFactory itemSourceFactory) {
        this.itemSourceFactory = itemSourceFactory;
        this.register("ComponentTemplate", new ComponentTemplateSetupOp(stepProcessor, valueResolver, this.itemSourceFactory));
        this.register("IndexTemplate", new IndexTemplateSetupOp(stepProcessor, valueResolver, this.itemSourceFactory));
        this.register("ILMPolicy", new ILMPolicySetupOp(stepProcessor, valueResolver, this.itemSourceFactory));
        this.register("DataStream", new DataStreamSetupOp(stepProcessor, this.itemSourceFactory));
    }

    public ElasticsearchOperationFactory(StepProcessor<SetupStep<Request, Response>> stepProcessor, ValueResolver valueResolver) {
        this(stepProcessor, valueResolver, (EmptyItemSourceFactory)ElasticsearchOperationFactory.createSetupOpsItemSourceFactory());
    }

    private static PooledItemSourceFactory createSetupOpsItemSourceFactory() {
        return new PooledItemSourceFactory.Builder().withPooledObjectOps((PooledObjectOps)new ByteBufPooledObjectOps(UnpooledByteBufAllocator.DEFAULT, (SizeLimitPolicy)new ByteBufBoundedSizeLimitPolicy(4096, 4096))).withInitialPoolSize(1).withResizePolicy((ResizePolicy)new UnlimitedResizePolicy.Builder().withResizeFactor(1.0).build()).build();
    }

    public void start() {
        if (this.isStarted()) {
            return;
        }
        LifeCycle.of((Object)this.itemSourceFactory).start();
        this.state = LifeCycle.State.STARTED;
    }

    public void stop() {
        if (this.isStopped()) {
            return;
        }
        LifeCycle.of((Object)this.itemSourceFactory).stop();
        this.state = LifeCycle.State.STOPPED;
    }

    public boolean isStarted() {
        return this.state == LifeCycle.State.STARTED;
    }

    public boolean isStopped() {
        return this.state == LifeCycle.State.STOPPED;
    }
}

