/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.hc;

import com.fasterxml.jackson.databind.ObjectWriter;
import io.netty.buffer.ByteBuf;
import org.appenders.log4j2.elasticsearch.BatchBuilder;
import org.appenders.log4j2.elasticsearch.BatchOperations;
import org.appenders.log4j2.elasticsearch.ItemSource;
import org.appenders.log4j2.elasticsearch.LifeCycle;
import org.appenders.log4j2.elasticsearch.PooledItemSourceFactory;
import org.appenders.log4j2.elasticsearch.hc.BatchRequest;
import org.appenders.log4j2.elasticsearch.hc.BatchResult;
import org.appenders.log4j2.elasticsearch.hc.ClientAPIFactory;
import org.appenders.log4j2.elasticsearch.hc.ElasticsearchBulkAPI;
import org.appenders.log4j2.elasticsearch.hc.IndexRequest;
import org.appenders.log4j2.elasticsearch.metrics.Measured;
import org.appenders.log4j2.elasticsearch.metrics.MetricsRegistry;

public class HCBatchOperations
implements BatchOperations<BatchRequest>,
LifeCycle,
Measured {
    private volatile LifeCycle.State state = LifeCycle.State.STOPPED;
    protected final PooledItemSourceFactory batchBufferFactory;
    private final ClientAPIFactory<IndexRequest.Builder, BatchRequest.Builder, BatchResult> builderFactory;
    private final String mappingType;

    @Deprecated
    public HCBatchOperations(PooledItemSourceFactory batchBufferFactory, String mappingType) {
        this.batchBufferFactory = batchBufferFactory;
        this.builderFactory = new ElasticsearchBulkAPI(mappingType, null);
        this.mappingType = mappingType;
    }

    @Deprecated
    public HCBatchOperations(PooledItemSourceFactory batchBufferFactory) {
        this(batchBufferFactory, (String)null);
    }

    public HCBatchOperations(PooledItemSourceFactory batchBufferFactory, ClientAPIFactory<IndexRequest.Builder, BatchRequest.Builder, BatchResult> builderFactory) {
        this.batchBufferFactory = batchBufferFactory;
        this.builderFactory = builderFactory;
        this.mappingType = null;
    }

    @Deprecated
    public String getMappingType() {
        return this.mappingType;
    }

    public Object createBatchItem(String target, Object source) {
        throw new UnsupportedOperationException("Use ItemSource based API instead");
    }

    public Object createBatchItem(String target, ItemSource payload) {
        return this.builderFactory.itemBuilder(target, payload).build();
    }

    public BatchBuilder<BatchRequest> createBatchBuilder() {
        return new BatchBuilder<BatchRequest>(){
            private final BatchRequest.Builder builder;
            {
                this.builder = ((BatchRequest.Builder)HCBatchOperations.this.builderFactory.batchBuilder()).withBuffer((ItemSource<ByteBuf>)HCBatchOperations.this.batchBufferFactory.createEmptySource());
            }

            public void add(Object item) {
                this.builder.add(item);
            }

            public BatchRequest build() {
                return this.builder.build();
            }
        };
    }

    @Deprecated
    protected ObjectWriter configuredWriter() {
        throw new UnsupportedOperationException("Moved to ElasticsearchBulk or peer");
    }

    public void start() {
        if (this.isStarted()) {
            return;
        }
        this.batchBufferFactory.start();
        this.state = LifeCycle.State.STARTED;
    }

    public void stop() {
        if (this.isStopped()) {
            return;
        }
        this.batchBufferFactory.stop();
        this.state = LifeCycle.State.STOPPED;
    }

    public boolean isStarted() {
        return this.state == LifeCycle.State.STARTED;
    }

    public boolean isStopped() {
        return this.state == LifeCycle.State.STOPPED;
    }

    public void register(MetricsRegistry registry) {
        Measured.of((Object)this.batchBufferFactory).register(registry);
    }

    public void deregister() {
        Measured.of((Object)this.batchBufferFactory).deregister();
    }
}

