/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.hc;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.function.Function;
import org.appenders.core.logging.InternalLogging;
import org.appenders.log4j2.elasticsearch.BatchOperations;
import org.appenders.log4j2.elasticsearch.LifeCycle;
import org.appenders.log4j2.elasticsearch.OperationFactory;
import org.appenders.log4j2.elasticsearch.backoff.BackoffPolicy;
import org.appenders.log4j2.elasticsearch.failover.FailedItemOps;
import org.appenders.log4j2.elasticsearch.hc.BatchRequest;
import org.appenders.log4j2.elasticsearch.hc.BatchResult;
import org.appenders.log4j2.elasticsearch.hc.BatchingClientObjectFactory;
import org.appenders.log4j2.elasticsearch.hc.HttpClientProvider;
import org.appenders.log4j2.elasticsearch.hc.IndexRequest;
import org.appenders.log4j2.elasticsearch.hc.ResponseHandler;
import org.appenders.log4j2.elasticsearch.hc.failover.HCFailedItemOps;
import org.appenders.log4j2.elasticsearch.metrics.Measured;
import org.appenders.log4j2.elasticsearch.metrics.MetricConfig;
import org.appenders.log4j2.elasticsearch.metrics.MetricsRegistry;

public class HCHttp
extends BatchingClientObjectFactory<BatchRequest, IndexRequest> {
    protected final BatchOperations<BatchRequest> batchOperations;
    protected final OperationFactory operationFactory;

    public HCHttp(Builder builder) {
        super(builder);
        this.batchOperations = builder.batchOperations;
        this.operationFactory = builder.operationFactory;
    }

    public static List<MetricConfig> metricConfigs(boolean enabled) {
        return BatchingClientObjectFactory.BatchingClientMetrics.createConfigs(enabled);
    }

    public BatchOperations<BatchRequest> createBatchOperations() {
        return this.batchOperations;
    }

    public OperationFactory setupOperationFactory() {
        return this.operationFactory;
    }

    @Override
    protected ResponseHandler<BatchResult> createResultHandler(BatchRequest request, Function<BatchRequest, Boolean> failureHandler) {
        return new HCResponseHandler(request, failureHandler);
    }

    public void startExtensions() {
        LifeCycle.of(this.batchOperations).start();
        LifeCycle.of((Object)this.operationFactory).start();
    }

    public void stopExtensions() {
        LifeCycle.of(this.batchOperations).stop();
        LifeCycle.of((Object)this.operationFactory).stop();
    }

    @Override
    public void register(MetricsRegistry registry) {
        super.register(registry);
        Measured.of(this.batchOperations).register(registry);
    }

    @Override
    public void deregister() {
        super.deregister();
        Measured.of(this.batchOperations).deregister();
    }

    private class HCResponseHandler
    implements ResponseHandler<BatchResult> {
        private final BatchRequest request;
        private final Function<BatchRequest, Boolean> failureHandler;

        public HCResponseHandler(BatchRequest request, Function<BatchRequest, Boolean> failureHandler) {
            this.request = request;
            this.failureHandler = failureHandler;
        }

        @Override
        public void completed(BatchResult result) {
            HCHttp.this.metrics.serverTookMs(result.getTook());
            HCHttp.this.backoffPolicy.deregister((Object)this.request);
            if (!result.isSucceeded()) {
                this.failureHandler.apply(this.request);
            } else {
                HCHttp.this.metrics.itemsDelivered(this.request.size());
            }
            this.request.completed();
        }

        @Override
        public void failed(Exception ex) {
            InternalLogging.getLogger().warn(ex.getMessage(), new Object[]{ex});
            HCHttp.this.backoffPolicy.deregister((Object)this.request);
            this.failureHandler.apply(this.request);
            this.request.completed();
        }

        @Override
        public BatchResult deserializeResponse(InputStream responseBody) throws IOException {
            return this.request.deserialize(responseBody);
        }
    }

    public static class Builder
    extends BatchingClientObjectFactory.Builder<BatchRequest, IndexRequest> {
        protected BatchOperations<BatchRequest> batchOperations;
        protected OperationFactory operationFactory;

        public HCHttp build() {
            return new HCHttp(this.validate());
        }

        protected Builder validate() {
            super.validate();
            if (this.operationFactory == null) {
                throw new IllegalArgumentException(this.nullValidationExceptionMessage(OperationFactory.class.getSimpleName()));
            }
            if (this.batchOperations == null) {
                throw new IllegalArgumentException(this.nullValidationExceptionMessage(BatchOperations.class.getSimpleName()));
            }
            return this;
        }

        private String nullValidationExceptionMessage(String className) {
            return String.format("No %s provided for %s", className, HCHttp.class.getSimpleName());
        }

        @Override
        protected FailedItemOps<IndexRequest> createFailedItemOps() {
            return new HCFailedItemOps();
        }

        public final Builder withClientProvider(HttpClientProvider clientProvider) {
            return (Builder)super.withClientProvider(clientProvider);
        }

        public final Builder withBackoffPolicy(BackoffPolicy<BatchRequest> backoffPolicy) {
            return (Builder)super.withBackoffPolicy(backoffPolicy);
        }

        public final Builder withFailedItemOps(FailedItemOps<IndexRequest> failedItemOps) {
            return (Builder)super.withFailedItemOps(failedItemOps);
        }

        public Builder withBatchOperations(BatchOperations<BatchRequest> batchOperations) {
            this.batchOperations = batchOperations;
            return this;
        }

        public Builder withOperationFactory(OperationFactory operationFactory) {
            this.operationFactory = operationFactory;
            return this;
        }
    }
}

