/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.hc;

import com.fasterxml.jackson.databind.ObjectReader;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.appenders.log4j2.elasticsearch.Auth;
import org.appenders.log4j2.elasticsearch.Deserializer;
import org.appenders.log4j2.elasticsearch.JacksonDeserializer;
import org.appenders.log4j2.elasticsearch.Log4j2Lookup;
import org.appenders.log4j2.elasticsearch.OperationFactory;
import org.appenders.log4j2.elasticsearch.PooledItemSourceFactory;
import org.appenders.log4j2.elasticsearch.ValueResolver;
import org.appenders.log4j2.elasticsearch.backoff.BackoffPolicy;
import org.appenders.log4j2.elasticsearch.backoff.NoopBackoffPolicy;
import org.appenders.log4j2.elasticsearch.hc.BatchRequest;
import org.appenders.log4j2.elasticsearch.hc.BatchResult;
import org.appenders.log4j2.elasticsearch.hc.ClientAPIFactory;
import org.appenders.log4j2.elasticsearch.hc.ElasticsearchBulkAPI;
import org.appenders.log4j2.elasticsearch.hc.ElasticsearchOperationFactory;
import org.appenders.log4j2.elasticsearch.hc.HCBatchOperations;
import org.appenders.log4j2.elasticsearch.hc.HCHttp;
import org.appenders.log4j2.elasticsearch.hc.HttpClient;
import org.appenders.log4j2.elasticsearch.hc.HttpClientFactory;
import org.appenders.log4j2.elasticsearch.hc.HttpClientProvider;
import org.appenders.log4j2.elasticsearch.hc.SyncStepProcessor;
import org.appenders.log4j2.elasticsearch.hc.discovery.ServiceDiscoveryFactory;
import org.appenders.log4j2.elasticsearch.metrics.DefaultMetricsFactory;
import org.appenders.log4j2.elasticsearch.metrics.MetricConfig;
import org.appenders.log4j2.elasticsearch.metrics.MetricsFactory;
import org.appenders.log4j2.elasticsearch.util.SplitUtil;

@Plugin(name="HCHttp", category="Core", elementType="objectFactory", printObject=true)
public class HCHttpPlugin
extends HCHttp {
    public static final String PLUGIN_NAME = "HCHttp";

    public HCHttpPlugin(HCHttp.Builder builder) {
        super(builder);
    }

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder
    implements org.apache.logging.log4j.core.util.Builder<HCHttpPlugin> {
        public static final int DEFAULT_RESPONSE_BUFFER_SIZE = 0x100000;
        @PluginConfiguration
        protected Configuration configuration;
        @PluginBuilderAttribute
        protected String serverUris;
        @PluginBuilderAttribute
        protected int connTimeout = 1000;
        @PluginBuilderAttribute
        protected int readTimeout = 0;
        @PluginBuilderAttribute
        protected int maxTotalConnections = 8;
        @PluginBuilderAttribute
        protected int ioThreadCount = Runtime.getRuntime().availableProcessors();
        @PluginBuilderAttribute
        protected boolean pooledResponseBuffers = true;
        @PluginBuilderAttribute
        protected int pooledResponseBuffersSizeInBytes = 0x100000;
        @PluginElement(value="auth")
        protected Auth<HttpClientFactory.Builder> auth;
        @PluginElement(value="itemSourceFactory")
        protected PooledItemSourceFactory pooledItemSourceFactory;
        @PluginBuilderAttribute
        @Deprecated
        protected String mappingType;
        @PluginElement(value="BackoffPolicy")
        protected BackoffPolicy<BatchRequest> backoffPolicy;
        @PluginElement(value="serviceDiscovery")
        protected ServiceDiscoveryFactory<HttpClient> serviceDiscoveryFactory;
        @PluginBuilderAttribute
        private String name = HCHttp.class.getSimpleName();
        @PluginElement(value="metricsFactory")
        private final MetricsFactory metricsFactory = new DefaultMetricsFactory(Collections.emptyList());
        protected ValueResolver valueResolver;
        @PluginElement(value="clientAPIFactory")
        private ClientAPIFactory clientAPIFactory;

        public HCHttpPlugin build() {
            HttpClientProvider clientProvider = this.createClientProvider();
            HCHttp.Builder builder = (HCHttp.Builder)new HCHttp.Builder().withBatchOperations(this.createBatchOperations()).withOperationFactory((OperationFactory)this.createOperationFactory(clientProvider)).withClientProvider(clientProvider).withBackoffPolicy((BackoffPolicy)(this.backoffPolicy == null ? new NoopBackoffPolicy() : this.backoffPolicy)).withName(this.name);
            for (MetricConfig metricConfig : this.metricsFactory.getMetricConfigs()) {
                builder.withMetricConfig(metricConfig);
            }
            return new HCHttpPlugin(builder.validate());
        }

        ValueResolver getValueResolver() {
            if (this.valueResolver != null) {
                return this.valueResolver;
            }
            if (this.configuration != null) {
                return new Log4j2Lookup(this.configuration.getStrSubstitutor());
            }
            return ValueResolver.NO_OP;
        }

        protected ElasticsearchOperationFactory createOperationFactory(HttpClientProvider clientProvider) {
            ObjectReader objectReader = ElasticsearchBulkAPI.defaultObjectMapper().readerFor(BatchResult.class);
            JacksonDeserializer deserializer = new JacksonDeserializer(objectReader);
            ValueResolver valueResolver = this.getValueResolver();
            return new ElasticsearchOperationFactory(new SyncStepProcessor(clientProvider, (Deserializer)deserializer), valueResolver);
        }

        protected HttpClientFactory.Builder createHttpClientFactoryBuilder() {
            return new HttpClientFactory.Builder().withName(this.name).withServerList(SplitUtil.split((String)this.serverUris, (String)";")).withConnTimeout(this.connTimeout).withReadTimeout(this.readTimeout).withMaxTotalConnections(this.maxTotalConnections).withIoThreadCount(this.ioThreadCount).withPooledResponseBuffers(this.pooledResponseBuffers).withPooledResponseBuffersSizeInBytes(this.pooledResponseBuffersSizeInBytes).withAuth(this.auth);
        }

        protected HttpClientProvider createClientProvider() {
            HttpClientFactory.Builder mainClientFactoryBuilder = this.createHttpClientFactoryBuilder();
            HttpClientProvider mainClientProvider = new HttpClientProvider(mainClientFactoryBuilder);
            if (this.serviceDiscoveryFactory != null) {
                mainClientFactoryBuilder.withServiceDiscovery(this.serviceDiscoveryFactory.create(mainClientProvider));
            }
            return mainClientProvider;
        }

        private HCBatchOperations createBatchOperations() {
            if (this.pooledItemSourceFactory == null) {
                throw new IllegalArgumentException(String.format("No %s provided for %s", PooledItemSourceFactory.class.getSimpleName(), HCHttp.class.getSimpleName()));
            }
            if (this.clientAPIFactory == null) {
                return new HCBatchOperations(this.pooledItemSourceFactory, this.mappingType);
            }
            return new HCBatchOperations(this.pooledItemSourceFactory, this.clientAPIFactory);
        }

        public Builder withServerUris(String serverUris) {
            this.serverUris = serverUris;
            return this;
        }

        public Builder withMaxTotalConnections(int maxTotalConnections) {
            this.maxTotalConnections = maxTotalConnections;
            return this;
        }

        public Builder withConnTimeout(int connTimeout) {
            this.connTimeout = connTimeout;
            return this;
        }

        public Builder withReadTimeout(int readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        public Builder withIoThreadCount(int ioThreadCount) {
            this.ioThreadCount = ioThreadCount;
            return this;
        }

        public Builder withItemSourceFactory(PooledItemSourceFactory pooledItemSourceFactory) {
            this.pooledItemSourceFactory = pooledItemSourceFactory;
            return this;
        }

        public Builder withBackoffPolicy(BackoffPolicy<BatchRequest> backoffPolicy) {
            this.backoffPolicy = backoffPolicy;
            return this;
        }

        public Builder withAuth(Auth<HttpClientFactory.Builder> auth) {
            this.auth = auth;
            return this;
        }

        @Deprecated
        public Builder withMappingType(String mappingType) {
            this.mappingType = mappingType;
            return this;
        }

        public Builder withClientAPIFactory(ClientAPIFactory clientAPIFactory) {
            this.clientAPIFactory = clientAPIFactory;
            return this;
        }

        public Builder withPooledResponseBuffers(boolean pooledResponseBuffersEnabled) {
            this.pooledResponseBuffers = pooledResponseBuffersEnabled;
            return this;
        }

        public Builder withPooledResponseBuffersSizeInBytes(int estimatedResponseSizeInBytes) {
            this.pooledResponseBuffersSizeInBytes = estimatedResponseSizeInBytes;
            return this;
        }

        public Builder withConfiguration(Configuration configuration) {
            this.configuration = configuration;
            return this;
        }

        public Builder withValueResolver(ValueResolver valueResolver) {
            this.valueResolver = valueResolver;
            return this;
        }

        public Builder withServiceDiscoveryFactory(ServiceDiscoveryFactory<HttpClient> serviceDiscoveryFactory) {
            this.serviceDiscoveryFactory = serviceDiscoveryFactory;
            return this;
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withMetricConfig(MetricConfig metricConfig) {
            this.metricsFactory.configure(metricConfig);
            return this;
        }

        public Builder withMetricConfigs(List<MetricConfig> metricConfigs) {
            this.metricsFactory.configure(metricConfigs);
            return this;
        }
    }
}

