/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.hc;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.appenders.log4j2.elasticsearch.ItemSource;
import org.appenders.log4j2.elasticsearch.hc.ByteBufEntityBuilder;
import org.appenders.log4j2.elasticsearch.hc.Request;
import org.appenders.log4j2.elasticsearch.hc.RequestFactory;

public class HCRequestFactory
implements RequestFactory<HttpUriRequest> {
    protected ContentType requestContentType = ContentType.APPLICATION_JSON.withCharset("utf-8");

    @Override
    public HttpUriRequest create(String url, Request request) throws IOException {
        HttpPost httpUriRequest;
        if (request.getHttpMethodName().equalsIgnoreCase("POST")) {
            httpUriRequest = new HttpPost(url);
        } else if (request.getHttpMethodName().equalsIgnoreCase("GET")) {
            httpUriRequest = new HttpGet(url);
        } else if (request.getHttpMethodName().equalsIgnoreCase("PUT")) {
            httpUriRequest = new HttpPut(url);
        } else if (request.getHttpMethodName().equalsIgnoreCase("HEAD")) {
            httpUriRequest = new HttpHead(url);
        } else {
            throw new UnsupportedOperationException(request.getHttpMethodName());
        }
        if (httpUriRequest instanceof HttpEntityEnclosingRequest) {
            ((HttpEntityEnclosingRequest)httpUriRequest).setEntity(this.createHttpEntity(request));
        }
        return httpUriRequest;
    }

    protected HttpEntity createHttpEntity(Request request) throws IOException {
        try {
            ItemSource serialize = request.serialize();
            ByteBuf byteBuf = (ByteBuf)serialize.getSource();
            return new ByteBufEntityBuilder().setByteBuf(byteBuf).setContentLength(byteBuf.writerIndex()).setContentType(this.requestContentType).build();
        }
        catch (Exception e) {
            throw new IOException("Unable to create HTTP entity", e);
        }
    }
}

