/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.hc;

import java.io.IOException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.nio.client.methods.HttpAsyncMethods;
import org.apache.http.protocol.HttpContext;
import org.appenders.core.logging.InternalLogging;
import org.appenders.log4j2.elasticsearch.LifeCycle;
import org.appenders.log4j2.elasticsearch.hc.BlockingResponseHandler;
import org.appenders.log4j2.elasticsearch.hc.HCResultCallback;
import org.appenders.log4j2.elasticsearch.hc.HttpAsyncResponseConsumerFactory;
import org.appenders.log4j2.elasticsearch.hc.Request;
import org.appenders.log4j2.elasticsearch.hc.RequestFactory;
import org.appenders.log4j2.elasticsearch.hc.Response;
import org.appenders.log4j2.elasticsearch.hc.ResponseHandler;
import org.appenders.log4j2.elasticsearch.hc.ServerPool;
import org.appenders.log4j2.elasticsearch.metrics.Measured;
import org.appenders.log4j2.elasticsearch.metrics.MetricsRegistry;

public class HttpClient
implements LifeCycle,
Measured {
    private volatile LifeCycle.State state = LifeCycle.State.STOPPED;
    private final CloseableHttpAsyncClient asyncClient;
    private final ServerPool serverPool;
    private final RequestFactory httpRequestFactory;
    private final HttpAsyncResponseConsumerFactory asyncResponseConsumerFactory;

    public HttpClient(CloseableHttpAsyncClient asyncClient, ServerPool serverPool, RequestFactory requestFactory, HttpAsyncResponseConsumerFactory asyncResponseConsumerFactory) {
        this.asyncClient = asyncClient;
        this.serverPool = serverPool;
        this.httpRequestFactory = requestFactory;
        this.asyncResponseConsumerFactory = asyncResponseConsumerFactory;
    }

    public <T extends Response> T execute(Request clientRequest, BlockingResponseHandler<T> responseHandler) {
        this.executeAsync(clientRequest, responseHandler);
        return responseHandler.getResult();
    }

    public <T extends Response> void executeAsync(Request request, ResponseHandler<T> responseHandler, HttpClientContext httpClientContext) {
        HttpUriRequest clientRequest;
        try {
            clientRequest = this.createClientRequest(request);
        }
        catch (Exception e) {
            responseHandler.failed(e);
            return;
        }
        FutureCallback<HttpResponse> responseCallback = this.createCallback(responseHandler);
        this.getAsyncClient().execute(HttpAsyncMethods.create((HttpUriRequest)clientRequest), this.asyncResponseConsumerFactory.create(), (HttpContext)httpClientContext, responseCallback);
    }

    public <T extends Response> void executeAsync(Request request, ResponseHandler<T> responseHandler) {
        this.executeAsync(request, responseHandler, this.createContextInstance());
    }

    HttpUriRequest createClientRequest(Request request) throws IOException {
        String url = this.serverPool.getNext() + '/' + request.getURI();
        return (HttpUriRequest)this.httpRequestFactory.create(url, request);
    }

    <T extends Response> FutureCallback<HttpResponse> createCallback(ResponseHandler<T> responseHandler) {
        return new HCResultCallback<T>(responseHandler);
    }

    HttpClientContext createContextInstance() {
        return HttpClientContext.create();
    }

    public CloseableHttpAsyncClient getAsyncClient() {
        return this.asyncClient;
    }

    public void start() {
        if (this.isStarted()) {
            return;
        }
        if (this.asyncResponseConsumerFactory instanceof LifeCycle) {
            ((LifeCycle)this.asyncResponseConsumerFactory).start();
        }
        this.asyncClient.start();
        this.state = LifeCycle.State.STARTED;
        InternalLogging.getLogger().debug("{}: Started", new Object[]{HttpClient.class.getSimpleName()});
    }

    public void stop() {
        if (this.isStopped()) {
            return;
        }
        InternalLogging.getLogger().debug("{}: Stopping client", new Object[]{HttpClient.class.getSimpleName()});
        if (this.asyncClient.isRunning()) {
            try {
                this.asyncClient.close();
            }
            catch (IOException e) {
                InternalLogging.getLogger().warn("Async client might not have been stopped properly. Cause: " + e.getMessage(), new Object[0]);
            }
        }
        if (this.asyncResponseConsumerFactory instanceof LifeCycle) {
            ((LifeCycle)this.asyncResponseConsumerFactory).stop();
        }
        Measured.of((Object)this.asyncResponseConsumerFactory).deregister();
        this.state = LifeCycle.State.STOPPED;
        InternalLogging.getLogger().debug("{}: Stopping client", new Object[]{HttpClient.class.getSimpleName()});
    }

    public boolean isStarted() {
        return this.state == LifeCycle.State.STARTED;
    }

    public boolean isStopped() {
        return this.state == LifeCycle.State.STOPPED;
    }

    public void register(MetricsRegistry registry) {
        Measured.of((Object)this.asyncResponseConsumerFactory).register(registry);
    }

    public void deregister() {
        Measured.of((Object)this.asyncResponseConsumerFactory).deregister();
    }
}

