/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.hc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.nio.client.methods.HttpAsyncMethods;
import org.apache.http.nio.conn.NHttpClientConnectionManager;
import org.apache.http.nio.conn.NoopIOSessionStrategy;
import org.apache.http.nio.conn.SchemeIOSessionStrategy;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.nio.reactor.IOReactorException;
import org.apache.http.nio.util.ByteBufferAllocator;
import org.apache.http.nio.util.HeapByteBufferAllocator;
import org.apache.http.nio.util.SimpleInputBuffer;
import org.appenders.log4j2.elasticsearch.Auth;
import org.appenders.log4j2.elasticsearch.GenericItemSourcePool;
import org.appenders.log4j2.elasticsearch.PooledObjectOps;
import org.appenders.log4j2.elasticsearch.ResizePolicy;
import org.appenders.log4j2.elasticsearch.UnlimitedResizePolicy;
import org.appenders.log4j2.elasticsearch.hc.HCRequestFactory;
import org.appenders.log4j2.elasticsearch.hc.HttpAsyncResponseConsumerFactory;
import org.appenders.log4j2.elasticsearch.hc.HttpClient;
import org.appenders.log4j2.elasticsearch.hc.PoolingAsyncResponseConsumer;
import org.appenders.log4j2.elasticsearch.hc.PoolingAsyncResponseConsumerFactory;
import org.appenders.log4j2.elasticsearch.hc.RequestFactory;
import org.appenders.log4j2.elasticsearch.hc.ServerPool;
import org.appenders.log4j2.elasticsearch.hc.SimpleInputBufferPooledObjectOps;
import org.appenders.log4j2.elasticsearch.hc.discovery.ServiceDiscovery;
import org.appenders.log4j2.elasticsearch.metrics.DefaultMetricsFactory;
import org.appenders.log4j2.elasticsearch.metrics.MetricConfig;
import org.appenders.log4j2.elasticsearch.metrics.MetricsFactory;

public class HttpClientFactory {
    protected final Collection<String> serverList;
    protected final int connTimeout;
    protected final int readTimeout;
    protected final int maxTotalConnections;
    protected final int ioThreadCount;
    protected final CredentialsProvider defaultCredentialsProvider;
    protected final LayeredConnectionSocketFactory sslSocketFactory;
    protected final ConnectionSocketFactory plainSocketFactory;
    protected final SchemeIOSessionStrategy httpIOSessionStrategy;
    protected final SchemeIOSessionStrategy httpsIOSessionStrategy;
    protected final boolean pooledResponseBuffersEnabled;
    protected final int pooledResponseBuffersSizeInBytes;
    protected final ServiceDiscovery serviceDiscovery;
    protected final MetricsFactory metricsFactory;
    private final String name;

    HttpClientFactory(Builder httpClientFactoryBuilder) {
        this.serverList = httpClientFactoryBuilder.serverList;
        this.connTimeout = httpClientFactoryBuilder.connTimeout;
        this.readTimeout = httpClientFactoryBuilder.readTimeout;
        this.maxTotalConnections = httpClientFactoryBuilder.maxTotalConnections;
        this.ioThreadCount = httpClientFactoryBuilder.ioThreadCount;
        this.defaultCredentialsProvider = httpClientFactoryBuilder.defaultCredentialsProvider;
        this.plainSocketFactory = httpClientFactoryBuilder.plainSocketFactory;
        this.sslSocketFactory = httpClientFactoryBuilder.sslSocketFactory;
        this.httpIOSessionStrategy = httpClientFactoryBuilder.httpIOSessionStrategy;
        this.httpsIOSessionStrategy = httpClientFactoryBuilder.httpsIOSessionStrategy;
        this.pooledResponseBuffersEnabled = httpClientFactoryBuilder.pooledResponseBuffersEnabled;
        this.pooledResponseBuffersSizeInBytes = httpClientFactoryBuilder.pooledResponseBuffersSizeInBytes;
        this.serviceDiscovery = httpClientFactoryBuilder.serviceDiscovery;
        this.metricsFactory = httpClientFactoryBuilder.metricsFactory;
        this.name = httpClientFactoryBuilder.name;
    }

    public HttpClient createInstance() {
        NHttpClientConnectionManager asyncConnectionManager = this.getAsyncConnectionManager();
        CloseableHttpAsyncClient asyncHttpClient = this.createAsyncHttpClient(asyncConnectionManager);
        HttpAsyncResponseConsumerFactory httpAsyncResponseConsumerFactory = this.createHttpAsyncResponseConsumerFactory();
        ServerPool serverPool = new ServerPool(new ArrayList<String>(this.serverList));
        if (this.serviceDiscovery != null) {
            this.serviceDiscovery.addListener(serverPool);
        }
        return this.createConfiguredClient(asyncHttpClient, serverPool, httpAsyncResponseConsumerFactory);
    }

    protected HttpAsyncResponseConsumerFactory createHttpAsyncResponseConsumerFactory() {
        if (this.pooledResponseBuffersEnabled) {
            String componentName = this.name == null ? HttpClient.class.getSimpleName() : this.name;
            return new PoolingAsyncResponseConsumerFactory(this.createPool(componentName), componentName, this.metricsFactory);
        }
        return HttpAsyncMethods::createConsumer;
    }

    protected HttpClient createConfiguredClient(CloseableHttpAsyncClient asyncHttpClient, ServerPool serverPool, HttpAsyncResponseConsumerFactory asyncResponseConsumerFactory) {
        return this.createConfiguredClient(asyncHttpClient, serverPool, this.createRequestFactory(), asyncResponseConsumerFactory);
    }

    protected HttpClient createConfiguredClient(CloseableHttpAsyncClient asyncHttpClient, ServerPool serverPool, RequestFactory requestFactory, HttpAsyncResponseConsumerFactory asyncResponseConsumerFactory) {
        return new HttpClient(asyncHttpClient, serverPool, requestFactory, asyncResponseConsumerFactory);
    }

    protected RequestFactory createRequestFactory() {
        return new HCRequestFactory();
    }

    protected CloseableHttpAsyncClient createAsyncHttpClient(NHttpClientConnectionManager connectionManager) {
        return HttpAsyncClients.custom().setConnectionManager(connectionManager).setDefaultRequestConfig(this.getDefaultRequestConfig()).setDefaultCredentialsProvider(this.defaultCredentialsProvider).build();
    }

    protected RequestConfig getDefaultRequestConfig() {
        return RequestConfig.custom().setConnectTimeout(this.connTimeout).setSocketTimeout(this.readTimeout).build();
    }

    protected NHttpClientConnectionManager getAsyncConnectionManager() {
        PoolingNHttpClientConnectionManager connectionManager = this.createUnconfiguredPoolingNHttpClientConnectionManager();
        connectionManager.setMaxTotal(this.maxTotalConnections);
        return connectionManager;
    }

    PoolingNHttpClientConnectionManager createUnconfiguredPoolingNHttpClientConnectionManager() {
        try {
            return new PoolingNHttpClientConnectionManager(this.createIOReactor(), this.createSchemeIOSessionStrategyRegistry());
        }
        catch (IOReactorException e) {
            throw new IllegalStateException(e);
        }
    }

    Registry<SchemeIOSessionStrategy> createSchemeIOSessionStrategyRegistry() {
        return RegistryBuilder.create().register("http", (Object)this.httpIOSessionStrategy).register("https", (Object)this.httpsIOSessionStrategy).build();
    }

    IOReactorConfig createIOReactorConfig() {
        return IOReactorConfig.custom().setConnectTimeout(this.connTimeout).setSoTimeout(this.readTimeout).setIoThreadCount(this.ioThreadCount).build();
    }

    ConnectingIOReactor createIOReactor() throws IOReactorException {
        return new DefaultConnectingIOReactor(this.createIOReactorConfig());
    }

    private GenericItemSourcePool<SimpleInputBuffer> createPool(String poolName) {
        return new GenericItemSourcePool(poolName, (PooledObjectOps)new SimpleInputBufferPooledObjectOps((ByteBufferAllocator)HeapByteBufferAllocator.INSTANCE, this.pooledResponseBuffersSizeInBytes), (ResizePolicy)new UnlimitedResizePolicy.Builder().withResizeFactor(0.5).build(), 1000L, this.maxTotalConnections, this.metricsFactory);
    }

    public static class Builder {
        protected Collection<String> serverList = new ArrayList<String>();
        protected int connTimeout = 1000;
        protected int readTimeout = 1000;
        protected int maxTotalConnections;
        protected int ioThreadCount = this.maxTotalConnections = 1;
        protected CredentialsProvider defaultCredentialsProvider;
        protected LayeredConnectionSocketFactory sslSocketFactory;
        protected ConnectionSocketFactory plainSocketFactory;
        protected SchemeIOSessionStrategy httpIOSessionStrategy;
        protected SchemeIOSessionStrategy httpsIOSessionStrategy;
        protected boolean pooledResponseBuffersEnabled;
        protected int pooledResponseBuffersSizeInBytes;
        protected Auth<Builder> auth;
        protected ServiceDiscovery serviceDiscovery;
        final MetricsFactory metricsFactory = new DefaultMetricsFactory().configure(PoolingAsyncResponseConsumer.metricConfigs(false)).configure(GenericItemSourcePool.metricConfigs((boolean)false));
        String name;

        public HttpClientFactory build() {
            return new HttpClientFactory(this.lazyInit());
        }

        protected Builder lazyInit() {
            if (this.auth != null) {
                this.auth.configure((Object)this);
            }
            if (this.sslSocketFactory == null) {
                this.sslSocketFactory = SSLConnectionSocketFactory.getSocketFactory();
            }
            if (this.plainSocketFactory == null) {
                this.plainSocketFactory = PlainConnectionSocketFactory.getSocketFactory();
            }
            if (this.httpIOSessionStrategy == null) {
                this.httpIOSessionStrategy = NoopIOSessionStrategy.INSTANCE;
            }
            if (this.httpsIOSessionStrategy == null) {
                this.httpsIOSessionStrategy = SSLIOSessionStrategy.getSystemDefaultStrategy();
            }
            return this;
        }

        public Builder withServerList(Collection<String> serverList) {
            this.serverList = serverList;
            return this;
        }

        public Builder withConnTimeout(int connTimeout) {
            this.connTimeout = connTimeout;
            return this;
        }

        public Builder withReadTimeout(int readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        public Builder withMaxTotalConnections(int maxTotalConnections) {
            this.maxTotalConnections = maxTotalConnections;
            return this;
        }

        public Builder withIoThreadCount(int ioThreadCount) {
            this.ioThreadCount = ioThreadCount;
            return this;
        }

        public Builder withPooledResponseBuffers(boolean pooledResponseBuffersEnabled) {
            this.pooledResponseBuffersEnabled = pooledResponseBuffersEnabled;
            return this;
        }

        public Builder withPooledResponseBuffersSizeInBytes(int pooledResponseBuffersSizeInBytes) {
            this.pooledResponseBuffersSizeInBytes = pooledResponseBuffersSizeInBytes;
            return this;
        }

        public Builder withAuth(Auth<Builder> auth) {
            this.auth = auth;
            return this;
        }

        public Builder withDefaultCredentialsProvider(CredentialsProvider credentialsProvider) {
            this.defaultCredentialsProvider = credentialsProvider;
            return this;
        }

        public Builder withSslSocketFactory(LayeredConnectionSocketFactory sslSocketFactory) {
            this.sslSocketFactory = sslSocketFactory;
            return this;
        }

        public Builder withPlainSocketFactory(ConnectionSocketFactory plainSocketFactory) {
            this.plainSocketFactory = plainSocketFactory;
            return this;
        }

        public Builder withHttpIOSessionStrategy(SchemeIOSessionStrategy httpIOSessionStrategy) {
            this.httpIOSessionStrategy = httpIOSessionStrategy;
            return this;
        }

        public Builder withHttpsIOSessionStrategy(SchemeIOSessionStrategy httpsIOSessionStrategy) {
            this.httpsIOSessionStrategy = httpsIOSessionStrategy;
            return this;
        }

        public Builder withServiceDiscovery(ServiceDiscovery serviceDiscovery) {
            this.serviceDiscovery = serviceDiscovery;
            return this;
        }

        public Builder withMetricConfigs(List<MetricConfig> metricConfigs) {
            this.metricsFactory.configure(metricConfigs);
            return this;
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public String toString() {
            return "Builder{serverList=" + this.serverList + ", connTimeout=" + this.connTimeout + ", readTimeout=" + this.readTimeout + ", maxTotalConnections=" + this.maxTotalConnections + ", ioThreadCount=" + this.ioThreadCount + ", pooledResponseBuffersEnabled=" + this.pooledResponseBuffersEnabled + ", pooledResponseBuffersSizeInBytes=" + this.pooledResponseBuffersSizeInBytes + ", auth=" + (this.auth != null) + ", serviceDiscovery=" + (this.serviceDiscovery != null) + ", metrics=" + this.metricsFactory.getMetricConfigs().size() + ", name='" + this.name + '\'' + '}';
        }
    }
}

