/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.hc;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.nio.conn.SchemeIOSessionStrategy;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import org.appenders.log4j2.elasticsearch.CertInfo;
import org.appenders.log4j2.elasticsearch.hc.HttpClientFactory;

public class JKSCertInfo
implements CertInfo<HttpClientFactory.Builder> {
    static final String configExceptionMessage = "Failed to apply SSL/TLS settings";
    private final String keystorePath;
    private final String truststorePath;
    private final String keystorePassword;
    private final String truststorePassword;

    public JKSCertInfo(String keystorePath, String keystorePassword, String truststorePath, String truststorePassword) {
        this.keystorePath = keystorePath;
        this.keystorePassword = keystorePassword;
        this.truststorePath = truststorePath;
        this.truststorePassword = truststorePassword;
    }

    public void applyTo(HttpClientFactory.Builder httpClientFactoryBuilder) {
        try (FileInputStream keystoreFile = new FileInputStream(new File(this.keystorePath));
             FileInputStream truststoreFile = new FileInputStream(new File(this.truststorePath));){
            KeyStore keyStore = KeyStore.getInstance("jks");
            keyStore.load(keystoreFile, this.keystorePassword.toCharArray());
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keyStore, this.keystorePassword.toCharArray());
            KeyStore trustStore = KeyStore.getInstance("jks");
            trustStore.load(truststoreFile, this.truststorePassword.toCharArray());
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(trustStore);
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
            httpClientFactoryBuilder.withSslSocketFactory((LayeredConnectionSocketFactory)new SSLConnectionSocketFactory(sslContext));
            httpClientFactoryBuilder.withHttpsIOSessionStrategy((SchemeIOSessionStrategy)new SSLIOSessionStrategy(sslContext, (HostnameVerifier)new NoopHostnameVerifier()));
        }
        catch (IOException | GeneralSecurityException e) {
            throw new IllegalArgumentException(configExceptionMessage, e);
        }
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        public static final String EMPTY_PASSWORD = "";
        private String keystorePath;
        private String keystorePassword = "";
        private String truststorePath;
        private String truststorePassword = "";

        public JKSCertInfo build() {
            if (this.keystorePath == null) {
                throw new IllegalArgumentException("No keystorePath provided for " + this.getClass().getSimpleName());
            }
            if (this.keystorePassword == null) {
                throw new IllegalArgumentException("No keystorePassword provided for " + this.getClass().getSimpleName());
            }
            if (this.truststorePath == null) {
                throw new IllegalArgumentException("No truststorePath provided for " + this.getClass().getSimpleName());
            }
            if (this.truststorePassword == null) {
                throw new IllegalArgumentException("No truststorePassword provided for " + this.getClass().getSimpleName());
            }
            return new JKSCertInfo(this.keystorePath, this.keystorePassword, this.truststorePath, this.truststorePassword);
        }

        public Builder withKeystorePath(String keystorePath) {
            this.keystorePath = keystorePath;
            return this;
        }

        public Builder withKeystorePassword(String keystorePassword) {
            this.keystorePassword = keystorePassword;
            return this;
        }

        public Builder withTruststorePath(String truststorePath) {
            this.truststorePath = truststorePath;
            return this;
        }

        public Builder withTruststorePassword(String truststorePassword) {
            this.truststorePassword = truststorePassword;
            return this;
        }
    }
}

