/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.hc;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import java.util.Optional;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.nio.conn.SchemeIOSessionStrategy;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import org.appenders.log4j2.elasticsearch.CertInfo;
import org.appenders.log4j2.elasticsearch.hc.HttpClientFactory;
import org.appenders.log4j2.elasticsearch.hc.thirdparty.PemReader;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public final class PEMCertInfo
implements CertInfo<HttpClientFactory.Builder> {
    static final String configExceptionMessage = "Failed to apply SSL/TLS settings";
    private final String keyPath;
    private final String keyPassphrase;
    private final String clientCertPath;
    private final String caPath;

    protected PEMCertInfo(String keyPath, String keyPassphrase, String clientCertPath, String caPath) {
        this.keyPath = keyPath;
        this.keyPassphrase = keyPassphrase;
        this.clientCertPath = clientCertPath;
        this.caPath = caPath;
    }

    public void applyTo(HttpClientFactory.Builder builder) {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        try (FileInputStream clientCert = new FileInputStream(new File(this.clientCertPath));
             FileInputStream key = new FileInputStream(new File(this.keyPath));
             FileInputStream certificateAuthoritiies = new FileInputStream(new File(this.caPath));){
            KeyStore keyStore = PemReader.loadKeyStore(clientCert, key, Optional.ofNullable(this.keyPassphrase));
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keyStore, this.keyPassphrase.toCharArray());
            KeyStore trustStore = PemReader.loadTrustStore(certificateAuthoritiies);
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(trustStore);
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
            builder.withSslSocketFactory((LayeredConnectionSocketFactory)new SSLConnectionSocketFactory(sslContext));
            builder.withHttpsIOSessionStrategy((SchemeIOSessionStrategy)new SSLIOSessionStrategy(sslContext, (HostnameVerifier)new NoopHostnameVerifier()));
        }
        catch (IOException | GeneralSecurityException e) {
            throw new IllegalArgumentException(configExceptionMessage, e);
        }
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String keyPath;
        private String clientCertPath;
        private String caPath;
        private String keyPassphrase;

        public PEMCertInfo build() {
            if (this.keyPath == null) {
                throw new IllegalArgumentException("No keyPath provided for " + this.getClass().getSimpleName());
            }
            if (this.clientCertPath == null) {
                throw new IllegalArgumentException("No clientCertPath provided for " + this.getClass().getSimpleName());
            }
            if (this.caPath == null) {
                throw new IllegalArgumentException("No caPath provided for " + this.getClass().getSimpleName());
            }
            return new PEMCertInfo(this.keyPath, this.keyPassphrase, this.clientCertPath, this.caPath);
        }

        public Builder withKeyPath(String keyPath) {
            this.keyPath = keyPath;
            return this;
        }

        public Builder withClientCertPath(String clientCertPath) {
            this.clientCertPath = clientCertPath;
            return this;
        }

        public Builder withCaPath(String caPath) {
            this.caPath = caPath;
            return this;
        }

        public Builder withKeyPassphrase(String keyPassphrase) {
            this.keyPassphrase = keyPassphrase;
            return this;
        }
    }
}

