/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.hc;

import org.apache.logging.log4j.core.config.ConfigurationException;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAliases;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;
import org.appenders.log4j2.elasticsearch.CertInfo;
import org.appenders.log4j2.elasticsearch.hc.HttpClientFactory;
import org.appenders.log4j2.elasticsearch.hc.PEMCertInfo;

@Plugin(name="PEM", category="Core", elementType="certInfo")
public class PEMCertInfoPlugin
implements CertInfo<HttpClientFactory.Builder> {
    static final String PLUGIN_NAME = "PEM";
    private final PEMCertInfo delegate;

    protected PEMCertInfoPlugin(String keyPath, String keyPassphrase, String clientCertPath, String caPath) {
        this.delegate = new PEMCertInfo(keyPath, keyPassphrase, clientCertPath, caPath);
    }

    public void applyTo(HttpClientFactory.Builder builder) {
        try {
            this.delegate.applyTo(builder);
        }
        catch (IllegalArgumentException e) {
            throw new ConfigurationException(e.getMessage());
        }
    }

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder
    implements org.apache.logging.log4j.core.util.Builder<PEMCertInfoPlugin> {
        @PluginBuilderAttribute
        @Required(message="No keyPath provided for PEM")
        private String keyPath;
        @PluginBuilderAttribute
        @Required(message="No clientCertPath provided for PEM")
        private String clientCertPath;
        @PluginBuilderAttribute
        @Required(message="No caPath provided for PEM")
        private String caPath;
        @PluginBuilderAttribute
        @PluginAliases(value={"keyPassword"})
        private String keyPassphrase;

        public PEMCertInfoPlugin build() {
            if (this.keyPath == null) {
                throw new ConfigurationException("No keyPath provided for PEM");
            }
            if (this.clientCertPath == null) {
                throw new ConfigurationException("No clientCertPath provided for PEM");
            }
            if (this.caPath == null) {
                throw new ConfigurationException("No caPath provided for PEM");
            }
            return new PEMCertInfoPlugin(this.keyPath, this.keyPassphrase, this.clientCertPath, this.caPath);
        }

        public Builder withKeyPath(String keyPath) {
            this.keyPath = keyPath;
            return this;
        }

        public Builder withClientCertPath(String clientCertPath) {
            this.clientCertPath = clientCertPath;
            return this;
        }

        public Builder withCaPath(String caPath) {
            this.caPath = caPath;
            return this;
        }

        public Builder withKeyPassphrase(String keyPassphrase) {
            this.keyPassphrase = keyPassphrase;
            return this;
        }
    }
}

