/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.hc;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.ContentDecoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.entity.ContentBufferEntity;
import org.apache.http.nio.protocol.AbstractAsyncResponseConsumer;
import org.apache.http.nio.util.ContentInputBuffer;
import org.apache.http.nio.util.SimpleInputBuffer;
import org.apache.http.protocol.HttpContext;
import org.appenders.log4j2.elasticsearch.ItemSource;
import org.appenders.log4j2.elasticsearch.ItemSourcePool;
import org.appenders.log4j2.elasticsearch.PoolResourceException;
import org.appenders.log4j2.elasticsearch.hc.ItemSourceContentInputStream;
import org.appenders.log4j2.elasticsearch.metrics.DefaultMetricsFactory;
import org.appenders.log4j2.elasticsearch.metrics.Metric;
import org.appenders.log4j2.elasticsearch.metrics.MetricConfig;
import org.appenders.log4j2.elasticsearch.metrics.MetricConfigFactory;
import org.appenders.log4j2.elasticsearch.metrics.Metrics;
import org.appenders.log4j2.elasticsearch.metrics.MetricsFactory;
import org.appenders.log4j2.elasticsearch.metrics.MetricsRegistry;

public class PoolingAsyncResponseConsumer
extends AbstractAsyncResponseConsumer<HttpResponse> {
    private final ItemSourcePool<SimpleInputBuffer> itemSourcePool;
    private volatile HttpResponse response;
    private volatile ItemSource<SimpleInputBuffer> buffer;
    private final AsyncResponseConsumerMetrics metrics;

    public PoolingAsyncResponseConsumer(AsyncResponseConsumerMetrics metrics, ItemSourcePool<SimpleInputBuffer> pool) {
        this.itemSourcePool = pool;
        this.metrics = metrics;
    }

    public PoolingAsyncResponseConsumer(ItemSourcePool<SimpleInputBuffer> bufferPool) {
        this.itemSourcePool = bufferPool;
        this.metrics = new AsyncResponseConsumerMetrics(PoolingAsyncResponseConsumer.class.getSimpleName(), (MetricsFactory)new DefaultMetricsFactory(PoolingAsyncResponseConsumer.metricConfigs(false)));
    }

    protected void onResponseReceived(HttpResponse response) {
        this.response = response;
    }

    protected void onEntityEnclosed(HttpEntity entity, ContentType contentType) throws IOException {
        if (this.buffer == null) {
            this.buffer = this.getPooled();
            ContentBufferEntity bufferedEntity = new ContentBufferEntity(entity, (ContentInputBuffer)this.buffer.getSource());
            bufferedEntity.setContent((InputStream)((Object)new ItemSourceContentInputStream(this.buffer)));
            this.response.setEntity((HttpEntity)bufferedEntity);
            this.metrics.recordContentLength((int)entity.getContentLength());
        }
    }

    protected void onContentReceived(ContentDecoder decoder, IOControl ioctrl) throws IOException {
        ((SimpleInputBuffer)this.buffer.getSource()).consumeContent(decoder);
    }

    protected void releaseResources() {
        this.response = null;
        this.buffer = null;
    }

    protected HttpResponse buildResult(HttpContext context) {
        return this.response;
    }

    ItemSource<SimpleInputBuffer> getPooled() throws IOException {
        try {
            return this.itemSourcePool.getPooled();
        }
        catch (PoolResourceException e) {
            throw new IOException("Unable get pooled response buffer: " + e.getMessage());
        }
    }

    public static List<MetricConfig> metricConfigs(boolean enabled) {
        ArrayList<MetricConfig> result = new ArrayList<MetricConfig>();
        result.add(MetricConfigFactory.createCountConfig((boolean)enabled, (String)"responseBytes"));
        return result;
    }

    static final class AsyncResponseConsumerMetrics
    implements Metrics {
        private final List<MetricsRegistry.Registration> registrations = new ArrayList<MetricsRegistry.Registration>();
        private final Metric responseContentLength;

        AsyncResponseConsumerMetrics(String name, MetricsFactory metricsFactory) {
            this.responseContentLength = metricsFactory.createMetric(name, "responseBytes");
        }

        void recordContentLength(int contentLength) {
            this.responseContentLength.store(contentLength);
        }

        public void register(MetricsRegistry registry) {
            this.registrations.add(registry.register(this.responseContentLength));
        }

        public void deregister() {
            this.registrations.forEach(MetricsRegistry.Registration::deregister);
            this.registrations.clear();
        }
    }
}

