/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.hc;

import org.apache.http.HttpResponse;
import org.apache.http.nio.protocol.HttpAsyncResponseConsumer;
import org.apache.http.nio.util.SimpleInputBuffer;
import org.appenders.log4j2.elasticsearch.GenericItemSourcePool;
import org.appenders.log4j2.elasticsearch.ItemSourcePool;
import org.appenders.log4j2.elasticsearch.LifeCycle;
import org.appenders.log4j2.elasticsearch.hc.HttpAsyncResponseConsumerFactory;
import org.appenders.log4j2.elasticsearch.hc.PoolingAsyncResponseConsumer;
import org.appenders.log4j2.elasticsearch.metrics.DefaultMetricsFactory;
import org.appenders.log4j2.elasticsearch.metrics.Measured;
import org.appenders.log4j2.elasticsearch.metrics.MetricsFactory;
import org.appenders.log4j2.elasticsearch.metrics.MetricsRegistry;

public class PoolingAsyncResponseConsumerFactory
implements HttpAsyncResponseConsumerFactory,
LifeCycle,
Measured {
    private volatile LifeCycle.State state = LifeCycle.State.STOPPED;
    private final GenericItemSourcePool<SimpleInputBuffer> pool;
    private final PoolingAsyncResponseConsumer.AsyncResponseConsumerMetrics metrics;

    public PoolingAsyncResponseConsumerFactory(GenericItemSourcePool<SimpleInputBuffer> pool) {
        this(pool, PoolingAsyncResponseConsumer.class.getSimpleName(), (MetricsFactory)new DefaultMetricsFactory(PoolingAsyncResponseConsumer.metricConfigs(false)));
    }

    public PoolingAsyncResponseConsumerFactory(GenericItemSourcePool<SimpleInputBuffer> pool, String name, MetricsFactory metricsFactory) {
        this.pool = pool;
        this.metrics = new PoolingAsyncResponseConsumer.AsyncResponseConsumerMetrics(name, metricsFactory);
    }

    @Override
    public HttpAsyncResponseConsumer<HttpResponse> create() {
        return new PoolingAsyncResponseConsumer(this.metrics, (ItemSourcePool<SimpleInputBuffer>)this.pool);
    }

    public void start() {
        if (!this.isStarted()) {
            this.pool.start();
            this.state = LifeCycle.State.STARTED;
        }
    }

    public void stop() {
        if (!this.isStopped()) {
            this.pool.stop();
            this.deregister();
            this.state = LifeCycle.State.STOPPED;
        }
    }

    public boolean isStarted() {
        return this.state == LifeCycle.State.STARTED;
    }

    public boolean isStopped() {
        return this.state == LifeCycle.State.STOPPED;
    }

    public void register(MetricsRegistry registry) {
        this.pool.register(registry);
        this.metrics.register(registry);
    }

    public void deregister() {
        this.pool.deregister();
        this.metrics.deregister();
    }
}

