/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.hc;

import org.appenders.core.logging.InternalLogging;
import org.appenders.log4j2.elasticsearch.ItemSource;
import org.appenders.log4j2.elasticsearch.Result;
import org.appenders.log4j2.elasticsearch.SetupStep;
import org.appenders.log4j2.elasticsearch.hc.GenericRequest;
import org.appenders.log4j2.elasticsearch.hc.Request;
import org.appenders.log4j2.elasticsearch.hc.Response;

public class PutComponentTemplate
extends SetupStep<Request, Response> {
    protected final String name;
    protected final ItemSource source;

    public PutComponentTemplate(String name, ItemSource itemSource) {
        this.name = name;
        this.source = itemSource;
    }

    public Result onResponse(Response response) {
        this.source.release();
        if (response.getResponseCode() == 200) {
            InternalLogging.getLogger().info("{}: Component template {} updated", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), this.name});
            return Result.SUCCESS;
        }
        InternalLogging.getLogger().error("{}: Unable to update component template: {}", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), response.getErrorMessage()});
        return Result.FAILURE;
    }

    public Request createRequest() {
        String uri = "_component_template/" + this.name;
        return new GenericRequest("PUT", uri, this.source);
    }
}

