/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.hc;

import org.appenders.core.logging.InternalLogging;
import org.appenders.log4j2.elasticsearch.ItemSource;
import org.appenders.log4j2.elasticsearch.Result;
import org.appenders.log4j2.elasticsearch.SetupStep;
import org.appenders.log4j2.elasticsearch.hc.GenericRequest;
import org.appenders.log4j2.elasticsearch.hc.Request;
import org.appenders.log4j2.elasticsearch.hc.Response;

public class PutIndexTemplate
extends SetupStep<Request, Response> {
    protected final int apiVersion;
    protected final String name;
    protected final ItemSource source;

    public PutIndexTemplate(String name, ItemSource source) {
        this(8, name, source);
    }

    public PutIndexTemplate(int apiVersion, String name, ItemSource source) {
        this.apiVersion = apiVersion;
        this.name = name;
        this.source = source;
    }

    public Result onResponse(Response response) {
        this.source.release();
        if (response.getResponseCode() == 200) {
            InternalLogging.getLogger().info("{}: Index template {} updated", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), this.name});
            return Result.SUCCESS;
        }
        InternalLogging.getLogger().error("{}: Unable to update index template: {}", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), response.getErrorMessage()});
        return Result.FAILURE;
    }

    public Request createRequest() {
        String uri = this.getVersionBasedUri();
        return new GenericRequest("PUT", uri, this.source);
    }

    private String getVersionBasedUri() {
        if (this.apiVersion < 8) {
            return "_template/" + this.name;
        }
        return "_index_template/" + this.name;
    }
}

