/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.hc;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import org.appenders.core.logging.InternalLogging;
import org.appenders.log4j2.elasticsearch.hc.discovery.ServerInfo;
import org.appenders.log4j2.elasticsearch.hc.discovery.ServerInfoListener;

public class ServerPool
implements ServerInfoListener {
    private static final String NAME = ServerPool.class.getSimpleName();
    private final int waitForHostsInterval = Integer.parseInt(System.getProperty("appenders.ServerPool.wait.interval", "200"));
    private final int waitForHostsRetries = Integer.parseInt(System.getProperty("appenders.ServerPool.wait.retries", "5"));
    private final AtomicInteger currentIndex = new AtomicInteger();
    private final AtomicReference<List<ServerInfo>> ref;

    public ServerPool(List<String> addresses) {
        if (addresses == null) {
            throw new IllegalArgumentException("Initial addresses cannot be null");
        }
        ArrayList<ServerInfo> resolved = new ArrayList<ServerInfo>(addresses.size());
        for (String initial : addresses) {
            ServerInfo serverInfo = new ServerInfo(initial);
            resolved.add(serverInfo);
        }
        this.ref = new AtomicReference(resolved);
    }

    public String getNext() {
        int retries = this.waitForHostsRetries;
        while (this.ref.get().size() == 0 && retries-- > 0) {
            LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(this.waitForHostsInterval));
            InternalLogging.getLogger().warn("No servers available", new Object[0]);
        }
        List<ServerInfo> serverInfos = this.ref.get();
        if (serverInfos.size() == 0) {
            throw new IllegalStateException("No servers available after " + this.waitForHostsRetries + " retries");
        }
        int next = Math.abs(this.currentIndex.getAndIncrement() % serverInfos.size());
        String resolvedAddress = serverInfos.get(next).getResolvedAddress();
        InternalLogging.getLogger().debug("{}: Returning {}", new Object[]{NAME, resolvedAddress});
        return resolvedAddress;
    }

    @Override
    public boolean onServerInfo(List<ServerInfo> serverInfos) {
        this.ref.set(serverInfos);
        return true;
    }
}

