/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.hc;

import com.fasterxml.jackson.databind.ObjectReader;
import java.util.function.Function;
import org.appenders.log4j2.elasticsearch.Deserializer;
import org.appenders.log4j2.elasticsearch.JacksonDeserializer;
import org.appenders.log4j2.elasticsearch.Result;
import org.appenders.log4j2.elasticsearch.SetupStep;
import org.appenders.log4j2.elasticsearch.StepProcessor;
import org.appenders.log4j2.elasticsearch.hc.BasicResponse;
import org.appenders.log4j2.elasticsearch.hc.BlockingResponseHandler;
import org.appenders.log4j2.elasticsearch.hc.HttpClientProvider;
import org.appenders.log4j2.elasticsearch.hc.Request;
import org.appenders.log4j2.elasticsearch.hc.Response;

public class SyncStepProcessor
implements StepProcessor<SetupStep<Request, Response>> {
    private final HttpClientProvider clientProvider;
    private final Deserializer responseDeserializer;

    @Deprecated
    public SyncStepProcessor(HttpClientProvider clientProvider, ObjectReader objectReader) {
        this(clientProvider, (Deserializer)new JacksonDeserializer(objectReader));
    }

    public SyncStepProcessor(HttpClientProvider clientProvider, Deserializer responseDeserializer) {
        this.responseDeserializer = responseDeserializer;
        this.clientProvider = clientProvider;
    }

    public Result process(SetupStep<Request, Response> setupStep) {
        BasicResponse response = this.clientProvider.createClient().execute((Request)setupStep.createRequest(), this.createBlockingResponseHandler());
        return setupStep.onResponse((Object)response);
    }

    final BlockingResponseHandler<BasicResponse> createBlockingResponseHandler() {
        return new BlockingResponseHandler<BasicResponse>(this.responseDeserializer, this.createBlockingResponseFallbackHandler());
    }

    final Function<Exception, BasicResponse> createBlockingResponseFallbackHandler() {
        return ex -> {
            BasicResponse basicResponse = new BasicResponse();
            if (ex != null) {
                basicResponse.withErrorMessage(ex.getMessage());
            }
            return basicResponse;
        };
    }
}

